/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.searchable;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.util.StringConverter;
import jidefx.scene.control.searchable.Searchable;

public class ChoiceBoxSearchable<T>
extends Searchable<T> {
    private ListChangeListener<T> _listChangeListener;
    private ChangeListener<ObservableList<T>> _itemsChangeListener;
    private BooleanProperty _showPopupProperty;

    public ChoiceBoxSearchable(ChoiceBox<T> choiceBox) {
        super((Node)choiceBox);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._listChangeListener == null) {
            this._listChangeListener = new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c) {
                    ChoiceBoxSearchable.this.hidePopup();
                }
            };
        }
        ((ChoiceBox)this._node).getItems().addListener(this._listChangeListener);
        if (this._itemsChangeListener == null) {
            this._itemsChangeListener = new ChangeListener<ObservableList<T>>(){

                public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                    ChoiceBoxSearchable.this.hidePopup();
                }
            };
        }
        ((ChoiceBox)this._node).itemsProperty().addListener(this._itemsChangeListener);
    }

    @Override
    public void uninstallListeners() {
        if (this._listChangeListener != null) {
            ((ChoiceBox)this._node).getItems().removeListener(this._listChangeListener);
            this._listChangeListener = null;
        }
        if (this._itemsChangeListener != null) {
            ((ChoiceBox)this._node).itemsProperty().removeListener(this._itemsChangeListener);
            this._itemsChangeListener = null;
        }
        super.uninstallListeners();
    }

    public BooleanProperty showPopupProperty() {
        if (this._showPopupProperty == null) {
            this._showPopupProperty = new SimpleBooleanProperty(false);
        }
        return this._showPopupProperty;
    }

    public boolean isShowPopup() {
        return this.showPopupProperty().get();
    }

    public void setShowPopup(boolean showPopup) {
        this.showPopupProperty().set(showPopup);
    }

    @Override
    protected int getSelectedIndex() {
        return ((ChoiceBox)this._node).getSelectionModel().getSelectedIndex();
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        ChoiceBox choiceBox = (ChoiceBox)this._node;
        choiceBox.getSelectionModel().select(index);
        if (this.isShowPopup() && !choiceBox.isShowing()) {
            choiceBox.show();
        }
    }

    @Override
    protected int getElementCount() {
        return ((ChoiceBox)this._node).getItems().size();
    }

    @Override
    protected T getElementAt(int index) {
        return (T)((ChoiceBox)this._node).getItems().get(index);
    }

    @Override
    protected String convertElementToString(T element) {
        ChoiceBox choiceBox = (ChoiceBox)this._node;
        StringConverter converter = choiceBox.getConverter();
        return converter != null ? converter.toString(element) : (element != null ? element.toString() : "");
    }
}

