/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.popup;

import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.PopupControl;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.stage.Window;
import jidefx.scene.control.popup.PopupOutline;
import jidefx.scene.control.popup.RectanglePopupOutline;
import jidefx.utils.PredefinedShapes;

public class ShapedPopup
extends PopupControl {
    private ObjectProperty<Node> _popupContentProperty;
    private ObjectProperty<Insets> _insetsProperty;
    private ObjectProperty<PopupOutline> _popupOutlineProperty;
    private BooleanProperty _closeButtonVisibleProperty;

    public ShapedPopup() {
        this.initializePopup();
        this.initializeStyle();
    }

    protected void initializePopup() {
        this.setAutoFix(false);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
    }

    protected void initializeStyle() {
    }

    private void initializePath() {
        Node content = this.getPopupContent();
        content.getStyleClass().add((Object)"shaped-popup-content");
        PopupOutline path = this.getPopupOutline();
        path.getStyleClass().add((Object)"shaped-popup-outline");
        this.customizePath(path);
        Button closeButton = new Button();
        closeButton.setVisible(this.isCloseButtonVisible());
        closeButton.getStyleClass().add((Object)"shaped-popup-close-button");
        closeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ShapedPopup.this.hide();
            }
        });
        closeButton.setStyle("-fx-background-color: #ffffff00;");
        Group clearIcon = PredefinedShapes.getInstance().createCloseIcon(20.0);
        clearIcon.setEffect((Effect)new DropShadow(2.0, Color.DARKGRAY));
        closeButton.setGraphic((Node)clearIcon);
        final AnchorPane anchorPane = new AnchorPane(new Node[]{path, content, closeButton});
        anchorPane.getStyleClass().add((Object)"shaped-popup");
        anchorPane.setEffect((Effect)new DropShadow(8.0, Color.DARKGRAY));
        path.widthProperty().bind((ObservableValue)anchorPane.widthProperty());
        path.heightProperty().bind((ObservableValue)anchorPane.heightProperty());
        Insets insets = this.getInsets();
        Insets padding = path.getContentPadding();
        AnchorPane.setTopAnchor((Node)content, (Double)(insets.getTop() + padding.getTop()));
        AnchorPane.setBottomAnchor((Node)content, (Double)(insets.getBottom() + padding.getBottom()));
        AnchorPane.setLeftAnchor((Node)content, (Double)(insets.getLeft() + padding.getLeft()));
        AnchorPane.setRightAnchor((Node)content, (Double)(insets.getRight() + padding.getRight()));
        this.adjustCloseButton(closeButton, padding);
        closeButton.setVisible(this.isCloseButtonVisible());
        Parent root = this.getScene().getRoot();
        if (root instanceof Group) {
            ((Group)root).getChildren().setAll((Object[])new Node[]{anchorPane});
        } else if (root instanceof Pane) {
            ((Pane)root).getChildren().setAll((Object[])new Node[]{anchorPane});
        }
        InvalidationListener invalidationListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                anchorPane.requestLayout();
            }
        };
        this.getScene().widthProperty().addListener(invalidationListener);
        this.getScene().heightProperty().addListener(invalidationListener);
    }

    protected void adjustCloseButton(Button closeButton, Insets padding) {
        AnchorPane.setTopAnchor((Node)closeButton, (Double)(padding.getTop() - 14.0));
        AnchorPane.setRightAnchor((Node)closeButton, (Double)(padding.getRight() - 14.0));
    }

    protected void customizePath(Path path) {
        path.setStroke((Paint)Color.LIGHTGRAY);
        path.setFill((Paint)Color.WHITE);
        path.setStrokeWidth(1.0);
        path.setSmooth(true);
    }

    public void show(Window owner) {
        throw new IllegalStateException("Please call one of the showPopup methods");
    }

    public void show(Node ownerNode, double screenX, double screenY) {
        throw new IllegalStateException("Please call one of the showPopup methods");
    }

    public void show(Window ownerWindow, double screenX, double screenY) {
        throw new IllegalStateException("Please call one of the showPopup methods");
    }

    public void showPopup(Node node, Pos pos) {
        this.showPopup(node, pos, 0.0, 0.0);
    }

    public void showPopup(final Node node, final Pos pos, final double xOffset, final double yOffset) {
        this.initializePath();
        Window w = node.getScene().getWindow();
        ChangeListener<Number> adjustListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (ShapedPopup.this.isShowing()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ShapedPopup.this.adjustPopup(node, pos, xOffset, yOffset, false);
                        }
                    };
                    Platform.runLater((Runnable)runnable);
                }
            }
        };
        w.xProperty().addListener((ChangeListener)adjustListener);
        w.yProperty().addListener((ChangeListener)adjustListener);
        w.widthProperty().addListener((ChangeListener)adjustListener);
        w.heightProperty().addListener((ChangeListener)adjustListener);
        this.getScene().widthProperty().addListener((ChangeListener)adjustListener);
        this.getScene().heightProperty().addListener((ChangeListener)adjustListener);
        this.adjustPopup(node, pos, xOffset, yOffset, true);
    }

    public void adjustPopup(Node node, Pos pos, double xOffset, double yOffset) {
        this.adjustPopup(node, pos, xOffset, yOffset, false);
    }

    private void adjustPopup(Node node, Pos pos, double xOffset, double yOffset, boolean show) {
        Bounds bounds = node.getBoundsInLocal();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        Point2D p = node.localToScreen(bounds.getMinX() + w / 2.0 + xOffset, bounds.getMinY() + h / 2.0 + yOffset);
        double x = p.getX();
        double y = p.getY();
        switch (pos) {
            case CENTER: 
            case BASELINE_CENTER: {
                break;
            }
            case CENTER_RIGHT: 
            case BASELINE_RIGHT: {
                x += w / 2.0;
                break;
            }
            case CENTER_LEFT: 
            case BASELINE_LEFT: {
                x -= w / 2.0;
                break;
            }
            case BOTTOM_RIGHT: {
                x += w / 2.0;
                y += h / 2.0;
                break;
            }
            case BOTTOM_LEFT: {
                x -= w / 2.0;
                y += h / 2.0;
                break;
            }
            case BOTTOM_CENTER: {
                y += h / 2.0;
                break;
            }
            case TOP_RIGHT: {
                x += w / 2.0;
                y -= h / 2.0;
                break;
            }
            case TOP_LEFT: {
                x -= w / 2.0;
                y -= h / 2.0;
                break;
            }
            case TOP_CENTER: {
                y -= h / 2.0;
            }
        }
        if (show) {
            super.show(node, x, y);
        }
        PopupOutline path = this.getPopupOutline();
        Point2D anchorPoint = path.getOriginPoint();
        this.setX(x - anchorPoint.getX());
        this.setY(y - anchorPoint.getY());
    }

    public ObjectProperty<Insets> insetsProperty() {
        if (this._insetsProperty == null) {
            this._insetsProperty = new SimpleObjectProperty((Object)this, "insets", (Object)new Insets(10.0));
        }
        return this._insetsProperty;
    }

    public Insets getInsets() {
        return (Insets)this.insetsProperty().get();
    }

    public void setInsets(Insets insets) {
        this.insetsProperty().set((Object)insets);
    }

    public ObjectProperty<Node> popupContentProperty() {
        if (this._popupContentProperty == null) {
            this._popupContentProperty = new SimpleObjectProperty((Object)this, "popupContent");
        }
        return this._popupContentProperty;
    }

    public Node getPopupContent() {
        return (Node)this.popupContentProperty().get();
    }

    public void setPopupContent(Node content) {
        this.popupContentProperty().set((Object)content);
    }

    public ObjectProperty<PopupOutline> popupOutlineProperty() {
        if (this._popupOutlineProperty == null) {
            this._popupOutlineProperty = new SimpleObjectProperty((Object)this, "popupOutline", (Object)new RectanglePopupOutline());
        }
        return this._popupOutlineProperty;
    }

    public PopupOutline getPopupOutline() {
        return (PopupOutline)((Object)this.popupOutlineProperty().get());
    }

    public void setPopupOutline(PopupOutline popupOutline) {
        this.popupOutlineProperty().set((Object)popupOutline);
    }

    public BooleanProperty closeButtonVisibleProperty() {
        if (this._closeButtonVisibleProperty == null) {
            this._closeButtonVisibleProperty = new SimpleBooleanProperty((Object)this, "closeButtonVisible", false);
        }
        return this._closeButtonVisibleProperty;
    }

    public boolean isCloseButtonVisible() {
        return this.closeButtonVisibleProperty().get();
    }

    public void setCloseButtonVisible(boolean closeButtonVisible) {
        this.closeButtonVisibleProperty().set(closeButtonVisible);
    }
}

