/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.hints;

import java.io.File;
import java.io.FilenameFilter;
import javafx.collections.FXCollections;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextInputControl;
import javafx.util.Callback;
import jidefx.scene.control.hints.AbstractListIntelliHints;

public class FileIntelliHints
extends AbstractListIntelliHints<String> {
    private boolean _folderOnly = false;
    private boolean _showFullPath = true;
    private FilenameFilter _filter;

    public FileIntelliHints(TextInputControl comp) {
        super(comp);
    }

    public boolean isFolderOnly() {
        return this._folderOnly;
    }

    public void setFolderOnly(boolean folderOnly) {
        this._folderOnly = folderOnly;
    }

    public boolean isShowFullPath() {
        return this._showFullPath;
    }

    public void setShowFullPath(boolean showFullPath) {
        this._showFullPath = showFullPath;
    }

    @Override
    public boolean updateHints(Object value) {
        String prefix;
        int index2;
        if (value == null) {
            return false;
        }
        String s = value.toString();
        if (s.length() == 0) {
            return false;
        }
        int index1 = s.lastIndexOf(92);
        int index = Math.max(index1, index2 = s.lastIndexOf(47));
        if (index == -1) {
            return false;
        }
        final String dir = s.substring(0, index + 1);
        Object[] files = new File(dir).list(new FilenameFilter(prefix = index == s.length() - 1 ? null : s.substring(index + 1).toLowerCase()){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                boolean result;
                if (FileIntelliHints.this.isFolderOnly() && new File(dir.getAbsolutePath() + File.separator + name).isFile()) {
                    return false;
                }
                boolean bl = result = this.val$prefix == null || name.toLowerCase().startsWith(this.val$prefix);
                if (result && FileIntelliHints.this.getFilter() != null) {
                    return FileIntelliHints.this.getFilter().accept(dir, name);
                }
                return result;
            }
        });
        if (files == null || files.length == 0 || files.length == 1 && files[0].equalsIgnoreCase(prefix)) {
            this.setAvailableHints(null);
            return false;
        }
        if (this.isShowFullPath()) {
            this.getListView().setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> param) {
                    return new ListCell<String>(){

                        protected void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setText(item == null ? "" : dir + item);
                        }
                    };
                }
            });
        }
        this.setAvailableHints(FXCollections.observableArrayList((Object[])files));
        return true;
    }

    @Override
    public void acceptHint(String selected) {
        int index2;
        int caretPosition;
        if (selected == null) {
            return;
        }
        String selectedValue = "" + selected;
        String value = this.getTextInputControl().getText();
        int index1 = value.lastIndexOf(92, caretPosition = this.getTextInputControl().getCaretPosition());
        int index = Math.max(index1, index2 = value.lastIndexOf(47, caretPosition));
        if (index == -1) {
            return;
        }
        int prefixLength = caretPosition - index - 1;
        this.getTextInputControl().insertText(caretPosition, selectedValue.substring(prefixLength));
    }

    public FilenameFilter getFilter() {
        return this._filter;
    }

    public void setFilter(FilenameFilter filter) {
        this._filter = filter;
    }
}

