/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.hints;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import jidefx.scene.control.hints.AbstractIntelliHints;

public abstract class AbstractListIntelliHints<T>
extends AbstractIntelliHints<T> {
    private ListView<T> _listView;

    public AbstractListIntelliHints(TextInputControl textInputControl) {
        super(textInputControl);
    }

    @Override
    public Node createHintsNode() {
        BorderPane pane = new BorderPane();
        this._listView = this.createListView();
        pane.setCenter(this._listView);
        return pane;
    }

    protected ListView<T> createListView() {
        ListView listView = new ListView();
        listView.setPrefHeight(215.0);
        return listView;
    }

    protected ListView<T> getListView() {
        return this._listView;
    }

    protected void setAvailableHints(ObservableList<T> hints) {
        if (this.getListView() == null) {
            return;
        }
        this.resetSelection();
        this.getListView().setItems(hints);
    }

    private void resetSelection() {
        if (this.getListView() == null) {
            return;
        }
        this.getListView().getSelectionModel().clearSelection();
    }

    @Override
    public T getSelectedHint() {
        return (T)(this.getListView() == null ? null : this.getListView().getSelectionModel().getSelectedItem());
    }

    @Override
    public Node getDelegateNode() {
        return this.getListView();
    }

    @Override
    public KeyCombination[] getDelegateKeyCombination() {
        return new KeyCombination[]{KeyCombination.keyCombination((String)"Down"), KeyCombination.keyCombination((String)"Up"), KeyCombination.keyCombination((String)"Page Down"), KeyCombination.keyCombination((String)"Page Up"), KeyCombination.keyCombination((String)"Ctrl+Page Up"), KeyCombination.keyCombination((String)"Ctrl+Page Down"), KeyCombination.keyCombination((String)"Ctrl+Home"), KeyCombination.keyCombination((String)"Ctrl+End")};
    }
}

