/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.hints;

import com.sun.javafx.event.EventUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.util.Duration;
import jidefx.scene.control.hints.IntelliHints;

public abstract class AbstractIntelliHints<T>
implements IntelliHints<T> {
    private Popup _popup;
    private TextInputControl _textInputControl;
    private Node _hintsNode;
    private boolean _keyTyped = false;
    private BooleanProperty _autoPopupProperty;
    private ObjectProperty<Duration> _showHintsDelayProperty;
    private List<KeyCombination> _showHintsKeyStrokes;
    EventHandler<KeyEvent> _keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            KeyCombination[] delegateKeyStrokes;
            if (event.getEventType() == KeyEvent.KEY_RELEASED && !AbstractIntelliHints.this.isHintsPopupVisible() && AbstractIntelliHints.this.getShowHintsKeyCombination().match(event)) {
                AbstractIntelliHints.this.showHintsPopup();
                event.consume();
                return;
            }
            if (AbstractIntelliHints.this.isHintsPopupVisible() && event.getEventType() == KeyEvent.KEY_RELEASED && KeyCombination.keyCombination((String)"Enter").match(event)) {
                AbstractIntelliHints.this.acceptHint();
            } else if (AbstractIntelliHints.this.isHintsPopupVisible() && event.getEventType() == KeyEvent.KEY_RELEASED && KeyCombination.keyCombination((String)"Escape").match(event)) {
                AbstractIntelliHints.this.rejectHint();
            } else {
                AbstractIntelliHints.this.setKeyTyped(true);
            }
            if (AbstractIntelliHints.this.getDelegateNode() != null && AbstractIntelliHints.this.isHintsPopupVisible() && (delegateKeyStrokes = AbstractIntelliHints.this.getDelegateKeyCombination()) != null) {
                for (KeyCombination combination : delegateKeyStrokes) {
                    if (!combination.match(event)) continue;
                    EventUtil.fireEvent((EventTarget)AbstractIntelliHints.this.getDelegateNode(), (Event)event);
                    event.consume();
                    return;
                }
            }
            if (AbstractIntelliHints.this.isHintsPopupVisible() && event.getEventType() == KeyEvent.KEY_PRESSED) {
                AbstractIntelliHints.this.acceptHint();
            }
        }
    };
    private ChangeListener<String> _textChangeListener = new ChangeListener<String>(){
        private Timeline timer;
        {
            this.timer = new Timeline(new KeyFrame[]{new KeyFrame(AbstractIntelliHints.this.getShowHintsDelay(), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    this.keyTyped();
                }
            }, new KeyValue[0])});
        }

        private void keyTyped() {
            if (AbstractIntelliHints.this.isKeyTyped()) {
                if (AbstractIntelliHints.this.isHintsPopupVisible() || AbstractIntelliHints.this.isAutoPopup()) {
                    AbstractIntelliHints.this.showHintsPopup();
                }
                AbstractIntelliHints.this.setKeyTyped(false);
            }
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            if (Duration.ZERO.equals((Object)AbstractIntelliHints.this.getShowHintsDelay())) {
                this.keyTyped();
            } else if (!Duration.INDEFINITE.equals((Object)AbstractIntelliHints.this.getShowHintsDelay())) {
                this.startTimer();
            }
        }

        void startTimer() {
            this.timer.setDelay(AbstractIntelliHints.this.getShowHintsDelay());
            if (this.timer.getStatus() == Animation.Status.RUNNING) {
                this.timer.stop();
                this.timer.play();
            } else {
                this.timer.setCycleCount(1);
                this.timer.play();
            }
        }
    };

    public AbstractIntelliHints(TextInputControl textInputControl) {
        this._textInputControl = textInputControl;
        this.getTextInputControl().getProperties().put((Object)"IntelliHints", (Object)this);
        this.getTextInputControl().textProperty().addListener(this._textChangeListener);
        this.getTextInputControl().addEventFilter(KeyEvent.ANY, this._keyEventHandler);
        this.getTextInputControl().focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    AbstractIntelliHints.this.hideHintsPopup();
                }
            }
        });
        this.addShowHintsKeyCombination(this.getShowHintsKeyCombination());
    }

    protected Popup createPopup() {
        return new Popup();
    }

    public TextInputControl getTextInputControl() {
        return this._textInputControl;
    }

    @Override
    public void acceptHint(T selected) {
        String newText;
        if (selected == null) {
            return;
        }
        int pos = this.getTextInputControl().getCaretPosition();
        if (this.isMultiline()) {
            String text = this.getTextInputControl().getText();
            int start = text.lastIndexOf(10, pos - 1);
            String remain = pos == -1 ? "" : text.substring(pos);
            text = text.substring(0, start + 1);
            text = text + selected;
            newText = text = text + remain;
        } else {
            newText = selected.toString();
        }
        this.getTextInputControl().setText(newText);
        String actualText = this.getTextInputControl().getText();
        int separatorIndex = actualText.indexOf(10, pos);
        int anchor = separatorIndex == -1 ? actualText.length() : separatorIndex;
        this.getTextInputControl().selectRange(anchor, anchor);
    }

    protected boolean isMultiline() {
        return this.getTextInputControl() instanceof TextArea;
    }

    protected void showHintsPopup() {
        TextInputControl control = this.getTextInputControl();
        if (control.isDisabled() || !control.isEditable() || !control.isFocused()) {
            return;
        }
        this.showHints();
    }

    public void showHints() {
        if (this._popup == null) {
            this._popup = this.createPopup();
        }
        if (this._hintsNode == null) {
            this._hintsNode = this.createHintsNode();
            this._popup.getContent().add((Object)this._hintsNode);
            this.getDelegateNode().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    AbstractIntelliHints.this.hideHintsPopup();
                    AbstractIntelliHints.this.setHintsEnabled(false);
                    AbstractIntelliHints.this.acceptHint(AbstractIntelliHints.this.getSelectedHint());
                    AbstractIntelliHints.this.setHintsEnabled(true);
                }
            });
        }
        if (this.updateHints(this.getContext())) {
            TextInputControl control = this.getTextInputControl();
            Bounds bounds = control.getBoundsInLocal();
            Point2D d = control.localToScreen(bounds.getMinX(), bounds.getMaxY());
            if (!this._popup.isShowing()) {
                this._popup.show((Node)control, d.getX(), d.getY());
            }
        } else {
            this.hideHintsPopup();
        }
    }

    protected Object getContext() {
        TextInputControl control = this.getTextInputControl();
        if (this.isMultiline()) {
            int pos = control.getCaretPosition();
            if (pos == 0) {
                return "";
            }
            String text = control.getText();
            int start = text.lastIndexOf(10, pos - 1);
            return text.substring(start + 1, pos);
        }
        return control.getText();
    }

    protected void hideHintsPopup() {
        if (this._popup != null) {
            this._popup.hide();
            this._popup = null;
            this._hintsNode = null;
        }
        this.setKeyTyped(false);
    }

    public void setHintsEnabled(boolean enabled) {
        if (!enabled) {
            this.getTextInputControl().textProperty().removeListener(this._textChangeListener);
            this.getTextInputControl().removeEventFilter(KeyEvent.ANY, this._keyEventHandler);
        } else {
            this.getTextInputControl().textProperty().addListener(this._textChangeListener);
            this.getTextInputControl().addEventFilter(KeyEvent.ANY, this._keyEventHandler);
        }
    }

    public boolean isHintsPopupVisible() {
        return this._popup != null && this._popup.isShowing();
    }

    public BooleanProperty autoPopupProperty() {
        if (this._autoPopupProperty == null) {
            this._autoPopupProperty = new SimpleBooleanProperty(true);
        }
        return this._autoPopupProperty;
    }

    public boolean isAutoPopup() {
        return this.autoPopupProperty().get();
    }

    public void setAutoPopup(boolean autoPopup) {
        this.autoPopupProperty().set(autoPopup);
    }

    protected abstract KeyCombination[] getDelegateKeyCombination();

    protected abstract Node getDelegateNode();

    protected KeyCombination getShowHintsKeyCombination() {
        if (this.isMultiline()) {
            return KeyCombination.keyCombination((String)"Ctrl+Space");
        }
        return KeyCombination.keyCombination((String)"Down");
    }

    private boolean acceptHint() {
        IntelliHints<T> hints = AbstractIntelliHints.getIntelliHints((Node)this.getTextInputControl());
        if (hints instanceof AbstractIntelliHints) {
            AbstractIntelliHints aih = (AbstractIntelliHints)hints;
            aih.hideHintsPopup();
            if (aih.getSelectedHint() != null) {
                aih.setHintsEnabled(false);
                aih.acceptHint(hints.getSelectedHint());
                aih.setHintsEnabled(true);
                return true;
            }
        }
        return false;
    }

    private void rejectHint() {
        this.hideHintsPopup();
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean keyTyped) {
        this._keyTyped = keyTyped;
    }

    public ObjectProperty<Duration> showHintsDelayProperty() {
        if (this._showHintsDelayProperty == null) {
            this._showHintsDelayProperty = new SimpleObjectProperty((Object)Duration.millis((double)200.0));
        }
        return this._showHintsDelayProperty;
    }

    public void setShowHintsDelay(Duration showHintsDelay) {
        this.showHintsDelayProperty().set((Object)showHintsDelay);
    }

    public Duration getShowHintsDelay() {
        return (Duration)this.showHintsDelayProperty().get();
    }

    public void addShowHintsKeyCombination(KeyCombination combination) {
        if (this._showHintsKeyStrokes == null) {
            this._showHintsKeyStrokes = new ArrayList<KeyCombination>();
        }
        this._showHintsKeyStrokes.add(combination);
    }

    public void removeShowHintKeyCombination(KeyCombination combination) {
        if (this._showHintsKeyStrokes != null) {
            this._showHintsKeyStrokes.remove(combination);
        }
    }

    public KeyCombination[] getAllShowHintsKeyStrokes() {
        if (this._showHintsKeyStrokes == null) {
            return new KeyCombination[0];
        }
        return this._showHintsKeyStrokes.toArray(new KeyCombination[this._showHintsKeyStrokes.size()]);
    }

    public static <T> IntelliHints<T> getIntelliHints(Node node) {
        return (IntelliHints)node.getProperties().get((Object)"IntelliHints");
    }
}

