/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.tree.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.tree.components.Tree;
import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="treeItem", tldTagClass="com.jgeppert.struts2.jquery.tree.views.jsp.ui.TreeItemTag", description="Item for the Tree Element", allowDynamicAttributes=true)
public class TreeItem
extends AbstractRemoteBean {
    public static final String TEMPLATE = "tree-item";
    public static final String TEMPLATE_CLOSE = "tree-item-close";
    public static final String COMPONENT_NAME = TreeItem.class.getName();
    public static final String JQUERYACTION = "treeitem";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_TREE = "tree";
    private static final String PARAM_PARENT_TREE_ITEM = "parentTreeItem";
    private static final String ID_PREFIX_TREEITEM = "treeitem_";
    protected String title;
    protected String type;

    public TreeItem(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        Component parentTreeItem;
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        this.addParameterIfPresent(PARAM_TITLE, this.title);
        this.addParameterIfPresent(PARAM_TYPE, this.type);
        this.addGeneratedIdParam(ID_PREFIX_TREEITEM);
        Component tree = this.findAncestor(Tree.class);
        if (tree != null) {
            this.addParameter(PARAM_TREE, ((Tree)tree).getId());
        }
        if ((parentTreeItem = this.findAncestor(TreeItem.class)) != null) {
            this.addParameter(PARAM_PARENT_TREE_ITEM, ((TreeItem)parentTreeItem).getId());
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Title for the Tree Item", required=true)
    public void setTitle(String title) {
        this.title = title;
    }

    @StrutsTagAttribute(description="The type property for node. This requires a valid types definition in the tree tag.")
    public void setType(String type) {
        this.type = type;
    }
}

