/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModSymbol;
import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.openjena.atlas.lib.StrUtils;
import tdb.cmdline.ModTDBDataset;

public abstract class CmdTDB
extends CmdARQ {
    private static final ArgDecl argNamedGraph = new ArgDecl(true, "graph");
    protected final ModTDBDataset tdbDatasetAssembler = new ModTDBDataset();
    private static final String log4Jsetup = StrUtils.strjoin((String)"\n", (String[])new String[]{"## Plain output to stdout", "log4j.appender.tdb.plain=org.apache.log4j.ConsoleAppender", "log4j.appender.tdb.plain.target=System.out", "log4j.appender.tdb.plain.layout=org.apache.log4j.PatternLayout", "log4j.appender.tdb.plain.layout.ConversionPattern=%m%n", "## Plain output with level, to stderr", "log4j.appender.tdb.plainlevel=org.apache.log4j.ConsoleAppender", "log4j.appender.tdb.plainlevel.target=System.err", "log4j.appender.tdb.plainlevel.layout=org.apache.log4j.PatternLayout", "log4j.appender.tdb.plainlevel.layout.ConversionPattern=%-5p %m%n", "## Everything", "log4j.rootLogger=INFO, tdb.plainlevel", "## Loader output", "log4j.additivity.com.hp.hpl.jena.tdb.loader=false", "log4j.logger.com.hp.hpl.jena.tdb.loader=INFO, tdb.plain", "## Parser output", "log4j.additivity.org.openjena.riot=false", "log4j.logger.org.openjena.riot=INFO, tdb.plainlevel "});
    private static boolean initialized = false;
    protected String graphName = null;

    protected CmdTDB(String[] argv) {
        super(argv);
        CmdTDB.init();
        super.add(argNamedGraph, "--graph=IRI", "Act on a named graph");
        super.addModule((ArgModuleGeneral)this.tdbDatasetAssembler);
        this.modVersion.addClass(Jena.class);
        this.modVersion.addClass(ARQ.class);
        this.modVersion.addClass(TDB.class);
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        String log4jProperty = System.getProperty("log4j.configuration");
        CmdTDB.setLogging();
        TDB.init();
        ModSymbol.addPrefixMapping((String)"tdb", (String)"http://jena.hpl.hp.com/TDB#");
    }

    public static void setLogging() {
        Properties p = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes((String)log4Jsetup));
        try {
            p.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyConfigurator.configure((Properties)p);
        SetupTDB.setOptimizerWarningFlag(false);
        System.setProperty("log4j.configuration", "set");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argNamedGraph)) {
            this.graphName = this.getValue(argNamedGraph);
        }
    }

    protected Model getModel() {
        Dataset ds = this.tdbDatasetAssembler.getDataset();
        if (this.graphName != null) {
            Model m = ds.getNamedModel(this.graphName);
            if (m == null) {
                throw new CmdException("No such named graph (is this a TDB dataset?)");
            }
            return m;
        }
        return ds.getDefaultModel();
    }

    protected Location getLocation() {
        return this.tdbDatasetAssembler.getLocation();
    }

    protected GraphTDB getGraph() {
        if (this.graphName != null) {
            return (GraphTDB)this.tdbDatasetAssembler.getDataset().getNamedModel(this.graphName).getGraph();
        }
        return (GraphTDB)this.tdbDatasetAssembler.getDataset().getDefaultModel().getGraph();
    }

    protected DatasetGraphTDB getDatasetGraph() {
        return (DatasetGraphTDB)this.getDataset().asDatasetGraph();
    }

    protected Dataset getDataset() {
        return this.tdbDatasetAssembler.getDataset();
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }
}

