/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyPolicyMRSW
implements ConcurrencyPolicy {
    private final boolean concurrencyChecking = true;
    private final AtomicLong epoch = new AtomicLong(5L);
    private final AtomicLong readCounter = new AtomicLong(0L);
    private final AtomicLong writeCounter = new AtomicLong(0L);

    @Override
    public void startRead() {
        this.readCounter.getAndIncrement();
        this.checkConcurrency();
    }

    @Override
    public void finishRead() {
        this.readCounter.decrementAndGet();
    }

    @Override
    public void startUpdate() {
        this.epoch.getAndIncrement();
        this.writeCounter.getAndIncrement();
        this.checkConcurrency();
    }

    @Override
    public void finishUpdate() {
        this.writeCounter.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConcurrency() {
        long W;
        long R;
        ConcurrencyPolicyMRSW concurrencyPolicyMRSW = this;
        synchronized (concurrencyPolicyMRSW) {
            R = this.readCounter.get();
            W = this.writeCounter.get();
        }
        if (R > 0L && W > 0L) {
            ConcurrencyPolicyMRSW.policyError(R, W);
        }
        if (W > 1L) {
            ConcurrencyPolicyMRSW.policyError(R, W);
        }
    }

    @Override
    public <T> Iterator<T> checkedIterator(Iterator<T> iter) {
        return new IteratorCheckNotConcurrent<T>(iter, this.epoch);
    }

    private static void policyError(long R, long W) {
        ConcurrencyPolicyMRSW.policyError(String.format("Reader = %d, Writer = %d", R, W));
    }

    private static void policyError(String message) {
        throw new ConcurrentModificationException(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorCheckNotConcurrent<T>
    implements Iterator<T> {
        private Iterator<T> iter;
        private AtomicLong eCount;
        private boolean finished = false;
        private long startEpoch;

        IteratorCheckNotConcurrent(Iterator<T> iter, AtomicLong eCount) {
            this.iter = iter;
            this.eCount = eCount;
            this.startEpoch = eCount.get();
        }

        private void checkCourrentModification() {
            if (this.finished) {
                return;
            }
            long now = this.eCount.get();
            if (now != this.startEpoch) {
                ConcurrencyPolicyMRSW.policyError(String.format("Iterator: started at %d, now %d", this.startEpoch, now));
            }
        }

        @Override
        public boolean hasNext() {
            this.checkCourrentModification();
            boolean b = this.iter.hasNext();
            if (!b) {
                this.finished = true;
            }
            return b;
        }

        @Override
        public T next() {
            this.checkCourrentModification();
            try {
                return this.iter.next();
            }
            catch (NoSuchElementException ex) {
                this.finished = true;
                throw ex;
            }
        }

        @Override
        public void remove() {
            this.checkCourrentModification();
            this.iter.remove();
        }
    }
}

