/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableConcrete;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import java.util.Iterator;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleTable
implements Sync,
Closeable {
    final NodeTupleTable table;
    private static Transform<Tuple<Node>, Triple> action = new Transform<Tuple<Node>, Triple>(){

        public Triple convert(Tuple<Node> item) {
            return new Triple((Node)item.get(0), (Node)item.get(1), (Node)item.get(2));
        }
    };

    public TripleTable(TupleIndex[] indexes, NodeTable nodeTable, ConcurrencyPolicy policy) {
        this.table = new NodeTupleTableConcrete(3, indexes, nodeTable, policy);
    }

    public boolean add(Triple triple) {
        return this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node s, Node p, Node o) {
        return this.table.addRow(s, p, o);
    }

    public boolean delete(Triple triple) {
        return this.table.deleteRow(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node s, Node p, Node o) {
        return this.table.deleteRow(s, p, o);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(s, p, o);
        if (iter == null) {
            return new NullIterator();
        }
        Iterator<Triple> iter2 = TupleLib.convertToTriples(this.table.getNodeTable(), iter);
        return iter2;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.table;
    }

    public void sync() {
        this.table.sync();
    }

    public void close() {
        this.table.close();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public void clearTriples() {
        this.table.clear();
    }
}

