/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.btree.BTreeNode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeRangeIterator
implements Iterator<Record> {
    private BTreeNode node;
    private int idx;
    private BTreeRangeIterator sub;
    private Record slot;
    private Record upperLimitRec = null;

    public static Iterator<Record> iterator(BTreeNode node, Record fromRec, Record toRec) {
        if (toRec != null && fromRec != null && Record.keyLE(toRec, fromRec)) {
            return Iter.nullIter();
        }
        int idxMin = -1;
        if (fromRec != null) {
            idxMin = node.findSlot(fromRec);
        }
        int idxMax = -node.count - 1;
        if (toRec != null) {
            idxMax = node.findSlot(toRec);
        }
        if (idxMin < 0 && idxMin == idxMax && !node.isLeaf) {
            int x = -(idxMin + 1);
            int subId = node.ptrs.get(x);
            BTreeNode n = node.pageMgr.get(subId, node.id);
            return n.iterator(fromRec, toRec);
        }
        return new BTreeRangeIterator(node, fromRec, idxMin, toRec, idxMax);
    }

    public static Iterator<Record> iterator(BTreeNode node) {
        return new BTreeRangeIterator(node);
    }

    private BTreeRangeIterator(BTreeNode node, Record fromRec, int idxMin, Record toRec, int idxMax) {
        this.init(node, fromRec, idxMin, toRec, idxMax);
    }

    private BTreeRangeIterator(BTreeNode node, Record fromRec, Record toRec) {
        int idxMin = -1;
        if (fromRec != null) {
            idxMin = node.findSlot(fromRec);
        }
        int idxMax = -node.count - 1;
        if (toRec != null) {
            idxMax = node.findSlot(toRec);
        }
        this.init(node, fromRec, idxMin, toRec, idxMax);
    }

    private BTreeRangeIterator(BTreeNode node) {
        this.node = node;
        this.idx = 0;
        this.slot = null;
        if (!node.isLeaf) {
            this.sub = this.makeSub(this.idx);
        }
        this.upperLimitRec = null;
    }

    private void init(BTreeNode node, Record fromRec, int idxMin, Record toRec, int idxMax) {
        this.node = node;
        if (idxMin >= 0) {
            this.slot = null;
            this.idx = idxMin;
        } else {
            this.slot = null;
            this.idx = -(idxMin + 1);
            if (!node.isLeaf) {
                BTreeNode sn = node.pageMgr.get(node.ptrs.get(this.idx), node.id);
                this.sub = new BTreeRangeIterator(sn, fromRec, toRec);
            }
        }
        this.upperLimitRec = toRec;
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.sub != null) {
            this.advanceSub();
            if (this.slot != null) {
                return true;
            }
            this.sub = null;
        }
        if (this.node.isLeaf) {
            if (this.idx < this.node.count) {
                Record r = this.node.records.get(this.idx);
                this.setSlot(r);
            }
            ++this.idx;
            return this.slot != null;
        }
        if (this.idx < this.node.count) {
            if (this.idx >= 0) {
                Record r = this.node.records.get(this.idx);
                this.setSlot(r);
            }
            ++this.idx;
            this.sub = this.makeSub(this.idx);
            if (this.slot != null) {
                return true;
            }
            this.advanceSub();
            return this.slot != null;
        }
        return false;
    }

    private void advanceSub() {
        if (this.sub.hasNext()) {
            this.setSlot(this.sub.next());
        } else {
            this.sub = null;
        }
    }

    private BTreeRangeIterator makeSub(int i) {
        BTreeNode sn = this.node.pageMgr.get(this.node.ptrs.get(i), this.node.id);
        return new BTreeRangeIterator(sn, null, this.upperLimitRec);
    }

    private void setSlot(Record rec) {
        if (this.upperLimitRec != null && Record.keyGE(rec, this.upperLimitRec)) {
            this.slot = null;
            return;
        }
        this.slot = rec;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record x = this.slot;
        this.slot = null;
        return x;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

