/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.btree.BTreeNode;
import com.hp.hpl.jena.tdb.index.btree.BTreePageMgr;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import com.hp.hpl.jena.tdb.sys.Session;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree
implements Iterable<Record>,
RangeIndex,
Session {
    private static Logger log = LoggerFactory.getLogger(BTree.class);
    private long sessionCounter = 0L;
    private int rootIdx;
    BTreeNode root;
    private BTreePageMgr pageMgr;
    private BTreeParams bTreeParams;

    public static BTree makeMem(int N, int keyLength, int valueLength) {
        return BTree.makeMem(null, N, keyLength, valueLength);
    }

    public static BTree makeMem(String name, int N, int keyLength, int valueLength) {
        BTreeParams params = new BTreeParams(N, keyLength, valueLength);
        BlockMgr mgr = BlockMgrFactory.createMem(name, params.getBlockSize());
        return new BTree(params, mgr);
    }

    public BTree(BTreeParams bTreeParams, BlockMgr blkMgr) {
        this.bTreeParams = bTreeParams;
        this.pageMgr = new BTreePageMgr(this, blkMgr);
        if (this.pageMgr.valid(0)) {
            this.startReadBlkMgr();
            this.root = this.pageMgr.getRoot(this.rootIdx);
            this.rootIdx = this.root.id;
            this.sessionCounter = 0L;
            this.finishReadBlkMgr();
        } else {
            this.startUpdateBlkMgr();
            this.root = this.pageMgr.createRoot();
            this.rootIdx = this.root.id;
            this.sessionCounter = 0L;
            if (BTreeParams.CheckingNode) {
                this.root.checkNodeDeep();
            }
            this.pageMgr.put(this.root);
            this.finishUpdateBlkMgr();
        }
    }

    BTreeParams getParams() {
        return this.bTreeParams;
    }

    BTreePageMgr getPageMgr() {
        return this.pageMgr;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.bTreeParams.recordFactory;
    }

    @Override
    public Record find(Record record) {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Record v = root.search(record);
        this.finishReadBlkMgr();
        return v;
    }

    private BTreeNode getRoot() {
        return this.root;
    }

    private void releaseRoot(BTreeNode root) {
        if (root != this.root) {
            log.warn("Root is not root!");
        }
    }

    @Override
    public boolean contains(Record record) {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Record r = root.search(record);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r != null;
    }

    @Override
    public Record minKey() {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Record r = root.minRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public Record maxKey() {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Record r = root.maxRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public boolean add(Record record) {
        return this.addAndReturnOld(record) == null;
    }

    public Record addAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BTreeNode root = this.getRoot();
        Record r = root.insert(record);
        if (r == null) {
            ++this.sessionCounter;
        }
        if (BTreeParams.CheckingBTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BTreeNode root = this.getRoot();
        Record r = root.delete(record);
        if (r != null) {
            --this.sessionCounter;
        }
        if (BTreeParams.CheckingBTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public Iterator<Record> iterator() {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Iterator<Record> iter = root.iterator();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    @Override
    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        Iterator<Record> iter = root.iterator(fromRec, toRec);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    @Override
    public boolean isEmpty() {
        this.startReadBlkMgr();
        BTreeNode root = this.getRoot();
        boolean b = root.getCount() == 0;
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return b;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RangeIndex(" + Utils.classShortName(this.getClass()) + ").clear");
    }

    public void sync() {
        if (this.pageMgr.getBlockMgr() != null) {
            this.pageMgr.getBlockMgr().sync();
        }
    }

    @Override
    public void close() {
        if (this.pageMgr.getBlockMgr() != null) {
            this.pageMgr.getBlockMgr().close();
        }
    }

    @Override
    public void startRead() {
    }

    @Override
    public void finishRead() {
    }

    @Override
    public void startUpdate() {
    }

    @Override
    public void finishUpdate() {
    }

    private void startReadBlkMgr() {
        this.pageMgr.startRead();
    }

    private void finishReadBlkMgr() {
        this.pageMgr.finishRead();
    }

    private void startUpdateBlkMgr() {
        this.pageMgr.startUpdate();
    }

    private void finishUpdateBlkMgr() {
        this.pageMgr.finishUpdate();
    }

    @Override
    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    @Override
    public long sessionTripleCount() {
        return this.sessionCounter;
    }

    public long sizeByCounting() {
        return this.root.sizeByCounting();
    }

    @Override
    public void check() {
        this.root.checkNodeDeep();
    }

    public void dump() {
        this.root.dump();
    }
}

