/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.IndexType;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBPlusTree;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBTree;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryExtHash;
import com.hp.hpl.jena.tdb.sys.SystemTDB;

public class IndexBuilder {
    private static IndexBuilder builder = IndexBuilder.chooseIndexBuilder();
    private static IndexBuilder builderMem = null;
    IndexFactory factoryIndex = null;
    IndexRangeFactory builderRangeIndex = null;

    public static IndexBuilder get() {
        return builder;
    }

    public static IndexBuilder getBTree() {
        return IndexBuilder.createIndexBuilder(IndexType.BTree);
    }

    public static IndexBuilder getBPlusTree() {
        return IndexBuilder.createIndexBuilder(IndexType.BPlusTree);
    }

    public static IndexBuilder getExtHash() {
        return IndexBuilder.createIndexBuilder(IndexType.ExtHash);
    }

    public static IndexBuilder mem() {
        return IndexBuilder.createIndexBuilderMem(SystemTDB.getIndexType());
    }

    public static String filenameForIndex(String indexName) {
        return indexName;
    }

    public static FileSet filesetForIndex(Location location, String indexName) {
        return new FileSet(location, IndexBuilder.filenameForIndex(indexName));
    }

    private static synchronized IndexBuilder chooseIndexBuilder() {
        return IndexBuilder.createIndexBuilder(SystemTDB.getIndexType());
    }

    private static IndexBuilder createIndexBuilderMem(IndexType indexType) {
        return IndexBuilder.createIndexBuilder(indexType);
    }

    private static IndexBuilder createIndexBuilder(IndexType indexType) {
        switch (indexType) {
            case BTree: {
                IndexFactoryBTree idx = new IndexFactoryBTree();
                return new IndexBuilder(idx, idx);
            }
            case BPlusTree: {
                IndexFactoryBPlusTree idx = new IndexFactoryBPlusTree();
                return new IndexBuilder(idx, idx);
            }
            case ExtHash: {
                IndexFactoryExtHash idxFactory = new IndexFactoryExtHash();
                IndexFactoryBPlusTree idx = new IndexFactoryBPlusTree();
                return new IndexBuilder(idxFactory, idx);
            }
        }
        throw new TDBException("Unrecognized index type: " + (Object)((Object)indexType));
    }

    public static Index createIndex(FileSet fileset, RecordFactory recordFactory) {
        return builder.newIndex(fileset, recordFactory);
    }

    public static RangeIndex createRangeIndex(FileSet fileset, RecordFactory recordFactory) {
        return builder.newRangeIndex(fileset, recordFactory);
    }

    public IndexBuilder(IndexFactory indexBuilder, IndexRangeFactory rangeIndexBuilder) {
        this.factoryIndex = indexBuilder;
        this.builderRangeIndex = rangeIndexBuilder;
    }

    public Index newIndex(FileSet fileset, RecordFactory factory) {
        return this.factoryIndex.createIndex(fileset, factory);
    }

    public RangeIndex newRangeIndex(FileSet fileset, RecordFactory factory) {
        return this.builderRangeIndex.createRangeIndex(fileset, factory);
    }
}

