/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrSync;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrCache
extends BlockMgrSync {
    private static Logger log = LoggerFactory.getLogger(BlockMgrCache.class);
    Cache<Integer, ByteBuffer> readCache = null;
    Cache<Integer, ByteBuffer> writeCache = null;
    public static boolean globalLogging = false;
    private boolean logging = false;
    private String indexName;
    long cacheHits = 0L;
    long cacheMisses = 0L;
    long cacheWriteHits = 0L;

    public BlockMgrCache(String indexName, int readSlots, int writeSlots, BlockMgr blockMgr) {
        super(blockMgr);
        this.indexName = String.format("%-12s", indexName);
        this.readCache = CacheFactory.createCache((int)readSlots);
        if (writeSlots > 0) {
            this.writeCache = CacheFactory.createCache((int)writeSlots);
            this.writeCache.setDropHandler((ActionKeyValue)new ActionKeyValue<Integer, ByteBuffer>(){

                public void apply(Integer id, ByteBuffer bb) {
                    BlockMgrCache.this.log("Cache spill: write block: %d", new Object[]{id});
                    if (bb == null) {
                        log.warn("Write cache: " + id + " dropping an entry that isn't there");
                        return;
                    }
                    BlockMgrCache.this.readCache.put((Object)id, (Object)bb);
                    BlockMgrCache.super.put(id, bb);
                }
            });
        }
    }

    public synchronized ByteBuffer get(int id) {
        ByteBuffer bb = (ByteBuffer)this.readCache.get((Object)id);
        if (bb != null) {
            ++this.cacheHits;
            this.log("Hit(r) : %d", id);
            return bb;
        }
        if (this.writeCache != null && (bb = (ByteBuffer)this.writeCache.get((Object)id)) != null) {
            ++this.cacheWriteHits;
            this.log("Hit(w) : %d", id);
            return bb;
        }
        ++this.cacheMisses;
        this.log("Miss  : %d", id);
        bb = super.get(id);
        this.readCache.put((Object)id, (Object)bb);
        return bb;
    }

    public synchronized void put(int id, ByteBuffer block) {
        this.log("Put   : %d", id);
        if (this.writeCache != null) {
            this.writeCache.put((Object)id, (Object)block);
        } else {
            super.put(id, block);
        }
    }

    public synchronized void freeBlock(int id) {
        this.log("Free  : %d", id);
        this.readCache.remove((Object)id);
        if (this.writeCache != null) {
            this.writeCache.remove((Object)id);
        }
        super.freeBlock(id);
    }

    public synchronized void sync() {
        String x = "";
        if (this.indexName != null) {
            x = this.indexName + " : ";
        }
        this.log("%sH=%d, M=%d, W=%d", x, this.cacheHits, this.cacheMisses, this.cacheWriteHits);
        if (this.writeCache != null) {
            this.log("sync (%d blocks)", this.writeCache.size());
        } else {
            this.log("sync", new Object[0]);
        }
        boolean somethingWritten = this.syncFlush();
        if (somethingWritten) {
            this.log("sync underlying BlockMgr", new Object[0]);
        } else {
            this.log("Empty sync", new Object[0]);
        }
    }

    private void log(String fmt, Object ... args) {
        if (!this.logging && !globalLogging) {
            return;
        }
        String msg = String.format(fmt, args);
        if (this.indexName != null) {
            msg = this.indexName + " : " + msg;
        }
        log.debug(msg);
    }

    public synchronized void close() {
        if (this.writeCache != null) {
            this.log("close (" + this.writeCache.size() + " blocks)", new Object[0]);
        }
        this.syncFlush();
        super.close();
    }

    private boolean syncFlush() {
        boolean didSync = false;
        if (this.writeCache != null) {
            this.log("Flush (write cache)", new Object[0]);
            long N = this.writeCache.size();
            Integer[] ids = new Integer[(int)N];
            Iterator iter = this.writeCache.keys();
            if (iter.hasNext()) {
                didSync = true;
            }
            int i = 0;
            while (iter.hasNext()) {
                ids[i] = (Integer)iter.next();
                ++i;
            }
            i = 0;
            while ((long)i < N) {
                Integer id = ids[i];
                this.expelEntry(id);
                ++i;
            }
        }
        return didSync;
    }

    private void expelEntry(Integer id) {
        ByteBuffer bb = (ByteBuffer)this.writeCache.get((Object)id);
        if (bb == null) {
            log.warn("Write cache: " + id + " expelling entry that isn't there");
            return;
        }
        this.log("Expel (write cache): %d", id);
        super.put(id, bb);
        this.writeCache.remove((Object)id);
        this.readCache.put((Object)id, (Object)bb);
    }
}

