/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.security;

import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.security.FirebaseAuthenticationProperties;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.security.firebase.FirebaseJwtTokenDecoder;
import com.google.cloud.spring.security.firebase.FirebaseTokenValidator;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@ConditionalOnClass(value={FirebaseTokenValidator.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.security.firebase.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@EnableConfigurationProperties(value={FirebaseAuthenticationProperties.class})
public class FirebaseAuthenticationAutoConfiguration {
    private static final String ISSUER_TEMPLATE = "https://securetoken.google.com/%s";
    private final String projectId;

    public FirebaseAuthenticationAutoConfiguration(GcpProjectIdProvider gcpProjectIdProvider, FirebaseAuthenticationProperties properties) {
        this.projectId = properties.getProjectId() != null ? properties.getProjectId() : gcpProjectIdProvider.getProjectId();
    }

    @Bean
    @ConditionalOnMissingBean(name={"firebaseJwtDelegatingValidator"})
    public DelegatingOAuth2TokenValidator<Jwt> firebaseJwtDelegatingValidator(JwtIssuerValidator jwtIssuerValidator, GcpProjectIdProvider gcpProjectIdProvider) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(jwtIssuerValidator);
        validators.add(new FirebaseTokenValidator(this.projectId));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    @Bean
    @ConditionalOnMissingBean(name={"firebaseAuthenticationJwtDecoder"})
    public JwtDecoder firebaseAuthenticationJwtDecoder(DelegatingOAuth2TokenValidator<Jwt> firebaseJwtDelegatingValidator, FirebaseAuthenticationProperties properties) {
        return new FirebaseJwtTokenDecoder(this.restOperations(), properties.getPublicKeysEndpoint(), firebaseJwtDelegatingValidator);
    }

    @Bean
    public JwtIssuerValidator jwtIssuerValidator(GcpProjectIdProvider gcpProjectIdProvider) {
        return new JwtIssuerValidator(String.format(ISSUER_TEMPLATE, this.projectId));
    }

    private RestOperations restOperations() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(2000);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

