package com.cybelia.sandra.entities.synchro;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class LogAbstract extends TopiaEntityAbstract implements Log {

    /**
     * Nom de l'attribut en BD : synchroNumber
     */
    protected long synchroNumber;

    /**
     * Nom de l'attribut en BD : timeStamp
     */
    protected long timeStamp;

    /**
     * Nom de l'attribut en BD : tourTopiaID
     */
    protected String tourTopiaID;

    /**
     * Nom de l'attribut en BD : typeModif
     */
    protected int typeModif;

    /**
     * Nom de l'attribut en BD : fichierSynchro
     */
    protected String fichierSynchro;

    /**
     * Nom de l'attribut en BD : camionTopiaID
     */
    protected String camionTopiaID;

    private static final long serialVersionUID = 3690248434280391223L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_SYNCHRO_NUMBER, long.class, synchroNumber);
        visitor.visit(this, PROPERTY_TIME_STAMP, long.class, timeStamp);
        visitor.visit(this, PROPERTY_TOUR_TOPIA_ID, String.class, tourTopiaID);
        visitor.visit(this, PROPERTY_TYPE_MODIF, int.class, typeModif);
        visitor.visit(this, PROPERTY_FICHIER_SYNCHRO, String.class, fichierSynchro);
        visitor.visit(this, PROPERTY_CAMION_TOPIA_ID, String.class, camionTopiaID);
        visitor.end(this);
    }

    @Override
    public void setSynchroNumber(long synchroNumber) {
        long oldValue = this.synchroNumber;
        fireOnPreWrite(PROPERTY_SYNCHRO_NUMBER, oldValue, synchroNumber);
        this.synchroNumber = synchroNumber;
        fireOnPostWrite(PROPERTY_SYNCHRO_NUMBER, oldValue, synchroNumber);
    }

    @Override
    public long getSynchroNumber() {
        fireOnPreRead(PROPERTY_SYNCHRO_NUMBER, synchroNumber);
        long result = this.synchroNumber;
        fireOnPostRead(PROPERTY_SYNCHRO_NUMBER, synchroNumber);
        return result;
    }

    @Override
    public void setTimeStamp(long timeStamp) {
        long oldValue = this.timeStamp;
        fireOnPreWrite(PROPERTY_TIME_STAMP, oldValue, timeStamp);
        this.timeStamp = timeStamp;
        fireOnPostWrite(PROPERTY_TIME_STAMP, oldValue, timeStamp);
    }

    @Override
    public long getTimeStamp() {
        fireOnPreRead(PROPERTY_TIME_STAMP, timeStamp);
        long result = this.timeStamp;
        fireOnPostRead(PROPERTY_TIME_STAMP, timeStamp);
        return result;
    }

    @Override
    public void setTourTopiaID(String tourTopiaID) {
        String oldValue = this.tourTopiaID;
        fireOnPreWrite(PROPERTY_TOUR_TOPIA_ID, oldValue, tourTopiaID);
        this.tourTopiaID = tourTopiaID;
        fireOnPostWrite(PROPERTY_TOUR_TOPIA_ID, oldValue, tourTopiaID);
    }

    @Override
    public String getTourTopiaID() {
        fireOnPreRead(PROPERTY_TOUR_TOPIA_ID, tourTopiaID);
        String result = this.tourTopiaID;
        fireOnPostRead(PROPERTY_TOUR_TOPIA_ID, tourTopiaID);
        return result;
    }

    @Override
    public void setTypeModif(int typeModif) {
        int oldValue = this.typeModif;
        fireOnPreWrite(PROPERTY_TYPE_MODIF, oldValue, typeModif);
        this.typeModif = typeModif;
        fireOnPostWrite(PROPERTY_TYPE_MODIF, oldValue, typeModif);
    }

    @Override
    public int getTypeModif() {
        fireOnPreRead(PROPERTY_TYPE_MODIF, typeModif);
        int result = this.typeModif;
        fireOnPostRead(PROPERTY_TYPE_MODIF, typeModif);
        return result;
    }

    @Override
    public void setFichierSynchro(String fichierSynchro) {
        String oldValue = this.fichierSynchro;
        fireOnPreWrite(PROPERTY_FICHIER_SYNCHRO, oldValue, fichierSynchro);
        this.fichierSynchro = fichierSynchro;
        fireOnPostWrite(PROPERTY_FICHIER_SYNCHRO, oldValue, fichierSynchro);
    }

    @Override
    public String getFichierSynchro() {
        fireOnPreRead(PROPERTY_FICHIER_SYNCHRO, fichierSynchro);
        String result = this.fichierSynchro;
        fireOnPostRead(PROPERTY_FICHIER_SYNCHRO, fichierSynchro);
        return result;
    }

    @Override
    public void setCamionTopiaID(String camionTopiaID) {
        String oldValue = this.camionTopiaID;
        fireOnPreWrite(PROPERTY_CAMION_TOPIA_ID, oldValue, camionTopiaID);
        this.camionTopiaID = camionTopiaID;
        fireOnPostWrite(PROPERTY_CAMION_TOPIA_ID, oldValue, camionTopiaID);
    }

    @Override
    public String getCamionTopiaID() {
        fireOnPreRead(PROPERTY_CAMION_TOPIA_ID, camionTopiaID);
        String result = this.camionTopiaID;
        fireOnPostRead(PROPERTY_CAMION_TOPIA_ID, camionTopiaID);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_SYNCHRO_NUMBER, this.synchroNumber).
            append(PROPERTY_TIME_STAMP, this.timeStamp).
            append(PROPERTY_TOUR_TOPIA_ID, this.tourTopiaID).
            append(PROPERTY_TYPE_MODIF, this.typeModif).
            append(PROPERTY_FICHIER_SYNCHRO, this.fichierSynchro).
            append(PROPERTY_CAMION_TOPIA_ID, this.camionTopiaID).
         toString();
        return result;
    }

} //LogAbstract
