package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class InfoAccessAbstract extends TopiaEntityAbstract implements InfoAccess {

    /**
     * Nom de l'attribut en BD : accesSilo
     */
    protected String accesSilo;

    /**
     * Nom de l'attribut en BD : modeChargement
     */
    protected String modeChargement;

    /**
     * Nom de l'attribut en BD : nomAcces
     */
    protected String nomAcces;

    /**
     * Nom de l'attribut en BD : type
     */
    protected int type;

    /**
     * Nom de l'attribut en BD : niveauSecurite
     */
    protected int niveauSecurite;

    /**
     * Nom de l'attribut en BD : commentaireSecurite
     */
    protected String commentaireSecurite;

    /**
     * Nom de l'attribut en BD : risques
     */
    protected Collection<String> risques;

    /**
     * Nom de l'attribut en BD : etat
     */
    protected int etat;

    /**
     * Nom de l'attribut en BD : eleveur
     */
    protected Eleveur eleveur;

    /**
     * Nom de l'attribut en BD : gps
     */
    protected PointGPS gps;

    /**
     * Nom de l'attribut en BD : trace
     */
    protected TraceGPS trace;

    /**
     * Nom de l'attribut en BD : usersVerrouillage
     */
    protected Collection<TaasUser> usersVerrouillage;

    private static final long serialVersionUID = 3832904342876284209L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ACCES_SILO, String.class, accesSilo);
        visitor.visit(this, PROPERTY_MODE_CHARGEMENT, String.class, modeChargement);
        visitor.visit(this, PROPERTY_NOM_ACCES, String.class, nomAcces);
        visitor.visit(this, PROPERTY_TYPE, int.class, type);
        visitor.visit(this, PROPERTY_NIVEAU_SECURITE, int.class, niveauSecurite);
        visitor.visit(this, PROPERTY_COMMENTAIRE_SECURITE, String.class, commentaireSecurite);
        visitor.visit(this, PROPERTY_RISQUES, Collection.class, String.class, risques);
        visitor.visit(this, PROPERTY_ETAT, int.class, etat);
        visitor.visit(this, PROPERTY_ELEVEUR, Eleveur.class, eleveur);
        visitor.visit(this, PROPERTY_GPS, PointGPS.class, gps);
        visitor.visit(this, PROPERTY_TRACE, TraceGPS.class, trace);
        visitor.visit(this, PROPERTY_USERS_VERROUILLAGE, Collection.class, TaasUser.class, usersVerrouillage);
        visitor.end(this);
    }

    @Override
    public void setAccesSilo(String accesSilo) {
        String oldValue = this.accesSilo;
        fireOnPreWrite(PROPERTY_ACCES_SILO, oldValue, accesSilo);
        this.accesSilo = accesSilo;
        fireOnPostWrite(PROPERTY_ACCES_SILO, oldValue, accesSilo);
    }

    @Override
    public String getAccesSilo() {
        fireOnPreRead(PROPERTY_ACCES_SILO, accesSilo);
        String result = this.accesSilo;
        fireOnPostRead(PROPERTY_ACCES_SILO, accesSilo);
        return result;
    }

    @Override
    public void setModeChargement(String modeChargement) {
        String oldValue = this.modeChargement;
        fireOnPreWrite(PROPERTY_MODE_CHARGEMENT, oldValue, modeChargement);
        this.modeChargement = modeChargement;
        fireOnPostWrite(PROPERTY_MODE_CHARGEMENT, oldValue, modeChargement);
    }

    @Override
    public String getModeChargement() {
        fireOnPreRead(PROPERTY_MODE_CHARGEMENT, modeChargement);
        String result = this.modeChargement;
        fireOnPostRead(PROPERTY_MODE_CHARGEMENT, modeChargement);
        return result;
    }

    @Override
    public void setNomAcces(String nomAcces) {
        String oldValue = this.nomAcces;
        fireOnPreWrite(PROPERTY_NOM_ACCES, oldValue, nomAcces);
        this.nomAcces = nomAcces;
        fireOnPostWrite(PROPERTY_NOM_ACCES, oldValue, nomAcces);
    }

    @Override
    public String getNomAcces() {
        fireOnPreRead(PROPERTY_NOM_ACCES, nomAcces);
        String result = this.nomAcces;
        fireOnPostRead(PROPERTY_NOM_ACCES, nomAcces);
        return result;
    }

    @Override
    public void setType(int type) {
        int oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public int getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        int result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public void setNiveauSecurite(int niveauSecurite) {
        int oldValue = this.niveauSecurite;
        fireOnPreWrite(PROPERTY_NIVEAU_SECURITE, oldValue, niveauSecurite);
        this.niveauSecurite = niveauSecurite;
        fireOnPostWrite(PROPERTY_NIVEAU_SECURITE, oldValue, niveauSecurite);
    }

    @Override
    public int getNiveauSecurite() {
        fireOnPreRead(PROPERTY_NIVEAU_SECURITE, niveauSecurite);
        int result = this.niveauSecurite;
        fireOnPostRead(PROPERTY_NIVEAU_SECURITE, niveauSecurite);
        return result;
    }

    @Override
    public void setCommentaireSecurite(String commentaireSecurite) {
        String oldValue = this.commentaireSecurite;
        fireOnPreWrite(PROPERTY_COMMENTAIRE_SECURITE, oldValue, commentaireSecurite);
        this.commentaireSecurite = commentaireSecurite;
        fireOnPostWrite(PROPERTY_COMMENTAIRE_SECURITE, oldValue, commentaireSecurite);
    }

    @Override
    public String getCommentaireSecurite() {
        fireOnPreRead(PROPERTY_COMMENTAIRE_SECURITE, commentaireSecurite);
        String result = this.commentaireSecurite;
        fireOnPostRead(PROPERTY_COMMENTAIRE_SECURITE, commentaireSecurite);
        return result;
    }

    @Override
    public void addRisques(String risques) {
        fireOnPreWrite(PROPERTY_RISQUES, null, risques);
        if (this.risques == null) {
            this.risques = new ArrayList<String>();
        }

        this.risques.add(risques);
        fireOnPostWrite(PROPERTY_RISQUES, this.risques.size(), null, risques);
    }

    @Override
    public void addAllRisques(Collection<String> risques) {
        if (risques == null) {
            return;
        }
        for (String item : risques) {
            addRisques(item);
        }
    }

    @Override
    public void setRisques(Collection<String> risques) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.risques != null ? new ArrayList<String>(this.risques) : null;
        fireOnPreWrite(PROPERTY_RISQUES, oldValue, risques);
        this.risques = risques;
        fireOnPostWrite(PROPERTY_RISQUES, oldValue, risques);
    }

    @Override
    public void removeRisques(String risques) {
        fireOnPreWrite(PROPERTY_RISQUES, risques, null);
        if (this.risques == null || !this.risques.remove(risques)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_RISQUES, this.risques.size() + 1, risques, null);
    }

    @Override
    public void clearRisques() {
        if (this.risques == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.risques);
        fireOnPreWrite(PROPERTY_RISQUES, oldValue, this.risques);
        this.risques.clear();
        fireOnPostWrite(PROPERTY_RISQUES, oldValue, this.risques);
    }

    @Override
    public Collection<String> getRisques() {
        return risques;
    }

    @Override
    public int sizeRisques() {
        if (risques == null) {
            return 0;
        }
        return risques.size();
    }

    @Override
    public boolean isRisquesEmpty() {
        int size = sizeRisques();
        return size == 0;
    }

    @Override
    public void setEtat(int etat) {
        int oldValue = this.etat;
        fireOnPreWrite(PROPERTY_ETAT, oldValue, etat);
        this.etat = etat;
        fireOnPostWrite(PROPERTY_ETAT, oldValue, etat);
    }

    @Override
    public int getEtat() {
        fireOnPreRead(PROPERTY_ETAT, etat);
        int result = this.etat;
        fireOnPostRead(PROPERTY_ETAT, etat);
        return result;
    }

    @Override
    public void setEleveur(Eleveur eleveur) {
        Eleveur oldValue = this.eleveur;
        fireOnPreWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
        this.eleveur = eleveur;
        fireOnPostWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
    }

    @Override
    public Eleveur getEleveur() {
        fireOnPreRead(PROPERTY_ELEVEUR, eleveur);
        Eleveur result = this.eleveur;
        fireOnPostRead(PROPERTY_ELEVEUR, eleveur);
        return result;
    }

    @Override
    public void setGps(PointGPS gps) {
        PointGPS oldValue = this.gps;
        fireOnPreWrite(PROPERTY_GPS, oldValue, gps);
        this.gps = gps;
        fireOnPostWrite(PROPERTY_GPS, oldValue, gps);
    }

    @Override
    public PointGPS getGps() {
        fireOnPreRead(PROPERTY_GPS, gps);
        PointGPS result = this.gps;
        fireOnPostRead(PROPERTY_GPS, gps);
        return result;
    }

    @Override
    public void setTrace(TraceGPS trace) {
        TraceGPS oldValue = this.trace;
        fireOnPreWrite(PROPERTY_TRACE, oldValue, trace);
        this.trace = trace;
        fireOnPostWrite(PROPERTY_TRACE, oldValue, trace);
    }

    @Override
    public TraceGPS getTrace() {
        fireOnPreRead(PROPERTY_TRACE, trace);
        TraceGPS result = this.trace;
        fireOnPostRead(PROPERTY_TRACE, trace);
        return result;
    }

    @Override
    public void addUsersVerrouillage(TaasUser usersVerrouillage) {
        fireOnPreWrite(PROPERTY_USERS_VERROUILLAGE, null, usersVerrouillage);
        if (this.usersVerrouillage == null) {
            this.usersVerrouillage = new ArrayList<TaasUser>();
        }

        this.usersVerrouillage.add(usersVerrouillage);
        fireOnPostWrite(PROPERTY_USERS_VERROUILLAGE, this.usersVerrouillage.size(), null, usersVerrouillage);
    }

    @Override
    public void addAllUsersVerrouillage(Collection<TaasUser> usersVerrouillage) {
        if (usersVerrouillage == null) {
            return;
        }
        for (TaasUser item : usersVerrouillage) {
            addUsersVerrouillage(item);
        }
    }

    @Override
    public void setUsersVerrouillage(Collection<TaasUser> usersVerrouillage) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasUser> oldValue = this.usersVerrouillage != null ? new ArrayList<TaasUser>(this.usersVerrouillage) : null;
        fireOnPreWrite(PROPERTY_USERS_VERROUILLAGE, oldValue, usersVerrouillage);
        this.usersVerrouillage = usersVerrouillage;
        fireOnPostWrite(PROPERTY_USERS_VERROUILLAGE, oldValue, usersVerrouillage);
    }

    @Override
    public void removeUsersVerrouillage(TaasUser usersVerrouillage) {
        fireOnPreWrite(PROPERTY_USERS_VERROUILLAGE, usersVerrouillage, null);
        if (this.usersVerrouillage == null || !this.usersVerrouillage.remove(usersVerrouillage)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_USERS_VERROUILLAGE, this.usersVerrouillage.size() + 1, usersVerrouillage, null);
    }

    @Override
    public void clearUsersVerrouillage() {
        if (this.usersVerrouillage == null) {
            return;
        }
        Collection<TaasUser> oldValue = new ArrayList<TaasUser>(this.usersVerrouillage);
        fireOnPreWrite(PROPERTY_USERS_VERROUILLAGE, oldValue, this.usersVerrouillage);
        this.usersVerrouillage.clear();
        fireOnPostWrite(PROPERTY_USERS_VERROUILLAGE, oldValue, this.usersVerrouillage);
    }

    @Override
    public Collection<TaasUser> getUsersVerrouillage() {
        return usersVerrouillage;
    }

    @Override
    public TaasUser getUsersVerrouillageByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(usersVerrouillage, topiaId);
    }

    @Override
    public int sizeUsersVerrouillage() {
        if (usersVerrouillage == null) {
            return 0;
        }
        return usersVerrouillage.size();
    }

    @Override
    public boolean isUsersVerrouillageEmpty() {
        int size = sizeUsersVerrouillage();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getGps());
        tmp.add(getTrace());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ACCES_SILO, this.accesSilo).
            append(PROPERTY_MODE_CHARGEMENT, this.modeChargement).
            append(PROPERTY_NOM_ACCES, this.nomAcces).
            append(PROPERTY_TYPE, this.type).
            append(PROPERTY_NIVEAU_SECURITE, this.niveauSecurite).
            append(PROPERTY_COMMENTAIRE_SECURITE, this.commentaireSecurite).
            append(PROPERTY_RISQUES, this.risques).
            append(PROPERTY_ETAT, this.etat).
            append(PROPERTY_GPS, this.gps).
            append(PROPERTY_TRACE, this.trace).
            append(PROPERTY_USERS_VERROUILLAGE, this.usersVerrouillage).
         toString();
        return result;
    }

} //InfoAccessAbstract
