package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class EtapeAbstract extends TopiaEntityAbstract implements Etape {

    /**
     * start from 0 (first etape chargement usine) to the end number of etape.
     * Nom de l'attribut en BD : ordre
     */
    protected int ordre;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : etat
     */
    protected int etat;

    /**
     * Nom de l'attribut en BD : tour
     */
    protected Tour tour;

    /**
     * Nom de l'attribut en BD : eleveur
     */
    protected Eleveur eleveur;

    /**
     * Nom de l'attribut en BD : produits
     */
    protected List<LigneProduit> produits;

    private static final long serialVersionUID = 7293127908543444579L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ORDRE, int.class, ordre);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_ETAT, int.class, etat);
        visitor.visit(this, PROPERTY_TOUR, Tour.class, tour);
        visitor.visit(this, PROPERTY_ELEVEUR, Eleveur.class, eleveur);
        visitor.visit(this, PROPERTY_PRODUITS, List.class, LigneProduit.class, produits);
        visitor.end(this);
    }

    @Override
    public void setOrdre(int ordre) {
        int oldValue = this.ordre;
        fireOnPreWrite(PROPERTY_ORDRE, oldValue, ordre);
        this.ordre = ordre;
        fireOnPostWrite(PROPERTY_ORDRE, oldValue, ordre);
    }

    @Override
    public int getOrdre() {
        fireOnPreRead(PROPERTY_ORDRE, ordre);
        int result = this.ordre;
        fireOnPostRead(PROPERTY_ORDRE, ordre);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setEtat(int etat) {
        int oldValue = this.etat;
        fireOnPreWrite(PROPERTY_ETAT, oldValue, etat);
        this.etat = etat;
        fireOnPostWrite(PROPERTY_ETAT, oldValue, etat);
    }

    @Override
    public int getEtat() {
        fireOnPreRead(PROPERTY_ETAT, etat);
        int result = this.etat;
        fireOnPostRead(PROPERTY_ETAT, etat);
        return result;
    }

    @Override
    public void setTour(Tour tour) {
        Tour oldValue = this.tour;
        fireOnPreWrite(PROPERTY_TOUR, oldValue, tour);
        this.tour = tour;
        fireOnPostWrite(PROPERTY_TOUR, oldValue, tour);
    }

    @Override
    public Tour getTour() {
        fireOnPreRead(PROPERTY_TOUR, tour);
        Tour result = this.tour;
        fireOnPostRead(PROPERTY_TOUR, tour);
        return result;
    }

    @Override
    public void setEleveur(Eleveur eleveur) {
        Eleveur oldValue = this.eleveur;
        fireOnPreWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
        this.eleveur = eleveur;
        fireOnPostWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
    }

    @Override
    public Eleveur getEleveur() {
        fireOnPreRead(PROPERTY_ELEVEUR, eleveur);
        Eleveur result = this.eleveur;
        fireOnPostRead(PROPERTY_ELEVEUR, eleveur);
        return result;
    }

    @Override
    public void addProduits(LigneProduit produits) {
        fireOnPreWrite(PROPERTY_PRODUITS, null, produits);
        if (this.produits == null) {
            this.produits = new ArrayList<LigneProduit>();
        }

        produits.setEtape(this);

        this.produits.add(produits);
        fireOnPostWrite(PROPERTY_PRODUITS, this.produits.size(), null, produits);
    }

    @Override
    public void addAllProduits(List<LigneProduit> produits) {
        if (produits == null) {
            return;
        }
        for (LigneProduit item : produits) {
            addProduits(item);
        }
    }

    @Override
    public void setProduits(List<LigneProduit> produits) {
        // Copy elements to keep data for fire with new reference
        List<LigneProduit> oldValue = this.produits != null ? new ArrayList<LigneProduit>(this.produits) : null;
        fireOnPreWrite(PROPERTY_PRODUITS, oldValue, produits);
        this.produits = produits;
        fireOnPostWrite(PROPERTY_PRODUITS, oldValue, produits);
    }

    @Override
    public void removeProduits(LigneProduit produits) {
        fireOnPreWrite(PROPERTY_PRODUITS, produits, null);
        if (this.produits == null || !this.produits.remove(produits)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        produits.setEtape(null);

        fireOnPostWrite(PROPERTY_PRODUITS, this.produits.size() + 1, produits, null);
    }

    @Override
    public void clearProduits() {
        if (this.produits == null) {
            return;
        }
        for (LigneProduit item : this.produits) {
            item.setEtape(null);
        }
        List<LigneProduit> oldValue = new ArrayList<LigneProduit>(this.produits);
        fireOnPreWrite(PROPERTY_PRODUITS, oldValue, this.produits);
        this.produits.clear();
        fireOnPostWrite(PROPERTY_PRODUITS, oldValue, this.produits);
    }

    @Override
    public List<LigneProduit> getProduits() {
        return produits;
    }

    @Override
    public LigneProduit getProduitsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(produits, topiaId);
    }

    @Override
    public int sizeProduits() {
        if (produits == null) {
            return 0;
        }
        return produits.size();
    }

    @Override
    public boolean isProduitsEmpty() {
        int size = sizeProduits();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getProduits() != null) {
              tmp.addAll(getProduits());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ORDRE, this.ordre).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_ETAT, this.etat).
            append(PROPERTY_ELEVEUR, this.eleveur).
         toString();
        return result;
    }

} //EtapeAbstract
