package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ActionSecuriteDAOAbstract<E extends ActionSecurite> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)ActionSecurite.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.ActionSecurite;
    }

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_TYPE, v);
        return result;
    }

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_TYPE, v);
        return result;
    }

    public E findByUserCreation(String v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_USER_CREATION, v);
        return result;
    }

    public List<E> findAllByUserCreation(String v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_USER_CREATION, v);
        return result;
    }

    public E findByDateCreation(Date v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_DATE_CREATION, v);
        return result;
    }

    public List<E> findAllByDateCreation(Date v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_DATE_CREATION, v);
        return result;
    }

    public E findByDateAction(Date v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_DATE_ACTION, v);
        return result;
    }

    public List<E> findAllByDateAction(Date v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_DATE_ACTION, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByEleveur(Eleveur v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_ELEVEUR, v);
        return result;
    }

    public List<E> findAllByEleveur(Eleveur v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_ELEVEUR, v);
        return result;
    }

    public E findByInfoAccess(InfoAccess v) throws TopiaException {
        E result = findByProperty(ActionSecurite.PROPERTY_INFO_ACCESS, v);
        return result;
    }

    public List<E> findAllByInfoAccess(InfoAccess v) throws TopiaException {
        List<E> result = findAllByProperty(ActionSecurite.PROPERTY_INFO_ACCESS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Eleveur.class) {
            EleveurDAO dao = (EleveurDAO)
                getContext().getDAO(Eleveur.class);
            tmp = dao.findAllContainsActionSecurite(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Eleveur.class, entity);
        if (!list.isEmpty()) {
            result.put(Eleveur.class, list);
        }

        return result;
    }

} //ActionSecuriteDAOAbstract<E extends ActionSecurite>
