/*
 * Decompiled with CFR 0.152.
 */
package com.github.rtyley.android.screenshot.paparazzo.processors;

import com.github.rtyley.android.screenshot.paparazzo.processors.ScreenshotProcessor;
import com.github.rtyley.android.screenshot.paparazzo.processors.util.Dimensions;
import com.github.rtyley.android.screenshot.paparazzo.processors.util.Images;
import java.awt.image.BufferedImage;
import java.util.Map;

public class ImageScaler
implements ScreenshotProcessor {
    private final ScreenshotProcessor delegate;
    private final Dimensions maxBounds;

    public ImageScaler(ScreenshotProcessor delegate, Dimensions maxBounds) {
        this.delegate = delegate;
        this.maxBounds = maxBounds;
    }

    @Override
    public void process(BufferedImage image, Map<String, String> request) {
        this.delegate.process(this.ensureWithinBounds(image), request);
    }

    private BufferedImage ensureWithinBounds(BufferedImage image) {
        Dimensions imageDimensions = new Dimensions(image.getWidth(), image.getHeight());
        if (this.maxBounds.contains(imageDimensions)) {
            return image;
        }
        return Images.imageToBufferedImage(Images.scaleTo(imageDimensions.scaledPreservingAspectRatioToFitWithin(this.maxBounds), image));
    }

    @Override
    public void finish() {
        this.delegate.finish();
    }
}

