/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import java.util.HashMap;
import java.util.Map;

public class ProtocVersion {
    public static final ProtocVersion PROTOC_VERSION = new ProtocVersion(null, null, "340");
    public final String mGroup;
    public final String mArtifact;
    public final String mVersion;
    private static Map<String, String> sVersionMap = new HashMap<String, String>();

    public static ProtocVersion getVersion(String spec) {
        if (!spec.startsWith("-v")) {
            return null;
        }
        String v = sVersionMap.get(spec.replace(".", ""));
        if (v != null) {
            return new ProtocVersion(null, null, v);
        }
        String[] as = spec.split(":");
        if (as.length == 4 && as[0].equals("-v")) {
            return new ProtocVersion(as[1], as[2], as[3]);
        }
        throw new IllegalArgumentException("Unsupported version: " + spec);
    }

    public ProtocVersion(String group, String artifact, String version) {
        this.mGroup = group;
        this.mArtifact = artifact;
        this.mVersion = version;
    }

    public String toString() {
        if (this.mArtifact == null) {
            return this.mVersion;
        }
        return this.mGroup + ":" + this.mArtifact + ":" + this.mVersion;
    }

    static {
        sVersionMap.put("-v340", "340");
        sVersionMap.put("-v330", "340");
        sVersionMap.put("-v320", "340");
        sVersionMap.put("-v310", "340");
        sVersionMap.put("-v300", "340");
        sVersionMap.put("-v261", "261");
        sVersionMap.put("-v250", "250");
        sVersionMap.put("-v241", "241");
    }
}

