/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.XmlException;
import com.github.oowekyala.ooxml.messages.XmlMessageHandler;
import com.github.oowekyala.ooxml.messages.XmlSeverity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AccumulatingMessageHandler
implements XmlMessageHandler,
AutoCloseable {
    private final EnumMap<XmlSeverity, Map<String, List<XmlException>>> entries = new EnumMap(XmlSeverity.class);
    protected final XmlSeverity minSeverity;
    protected final XmlMessageHandler basePrinter;

    public AccumulatingMessageHandler(XmlMessageHandler basePrinter, XmlSeverity minSeverity) {
        this.basePrinter = basePrinter;
        this.minSeverity = minSeverity;
    }

    @Override
    public void accept(XmlException ex) {
        this.entries.computeIfAbsent(ex.getSeverity(), s -> new HashMap()).computeIfAbsent(ex.getSimpleMessage(), m -> new ArrayList()).add(ex);
    }

    protected abstract void printSummaryLine(String var1, XmlSeverity var2, String var3);

    @Override
    public void close() {
        this.close(this.minSeverity, this.minSeverity);
    }

    public void close(XmlSeverity minSeverityToPrintSummary, XmlSeverity minSeverityToPrintFully) {
        this.entries.forEach((severity, entriesByMessage) -> {
            if (severity.compareTo(minSeverityToPrintFully) >= 0) {
                entriesByMessage.forEach((message, entry) -> this.printFully((XmlSeverity)((Object)severity), (String)message, (List<XmlException>)entry));
            } else if (severity.compareTo(minSeverityToPrintSummary) >= 0) {
                entriesByMessage.forEach((message, entry) -> this.printSummary((XmlSeverity)((Object)severity), (String)message, (List<XmlException>)entry));
            } else {
                this.dontPrint((XmlSeverity)((Object)severity), (Map<String, List<XmlException>>)entriesByMessage);
            }
        });
    }

    protected void printFully(XmlSeverity severity, String message, List<XmlException> entry) {
        for (XmlException e : entry) {
            this.basePrinter.accept(e);
        }
    }

    protected void printSummary(XmlSeverity severity, String message, List<XmlException> entry) {
        XmlException first = entry.get(0);
        if (entry.size() > 1) {
            String kind = first.getKind();
            this.printSummaryLine(kind, severity, "There were " + entry.size() + " " + severity.toString().toLowerCase(Locale.ROOT) + " like the following one:");
        }
        this.basePrinter.accept(first);
    }

    protected void dontPrint(XmlSeverity severity, Map<String, List<XmlException>> entriesByMessage) {
    }
}

