package com.github.markzhai.uiframework.common;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;

public class ParcelableBinder implements Parcelable {

    private final IBinder mBinder;

    public ParcelableBinder(IBinder binder) {
        mBinder = binder;
    }

    private ParcelableBinder(Parcel parcel) {
        mBinder = parcel.readStrongBinder();
    }

    public IBinder getBinder() {
        return mBinder;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(mBinder);
    }

    public final static Creator<ParcelableBinder> CREATOR = new Creator<ParcelableBinder>() {
        @Override
        public ParcelableBinder createFromParcel(Parcel source) {
            return new ParcelableBinder(source);
        }

        @Override
        public ParcelableBinder[] newArray(int size) {
            return new ParcelableBinder[size];
        }
    };
}
