/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.util.Locale;
import java.util.Properties;

public class TranslationSource {
    private static Properties translationResources;
    private static final String propertiesFileName = "TranslationResources.properties";

    public static String getTranslation(Locale locale, String key, String defaultText) {
        TranslationSource.initializePropertiesIfNeeded();
        String language = locale.getLanguage();
        if (language == null || language.isEmpty()) {
            return defaultText;
        }
        String propertyKey = language + ".text." + key;
        String result = translationResources.getProperty(propertyKey, defaultText);
        return result;
    }

    private static void initializePropertiesIfNeeded() {
        if (translationResources != null) {
            return;
        }
        String lastException = "";
        try {
            translationResources = new Properties();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            translationResources.load(classLoader.getResourceAsStream(propertiesFileName));
        }
        catch (Exception exception) {
            lastException = exception.toString() + "\n----\n" + exception.getMessage();
        }
        if (translationResources == null) {
            throw new RuntimeException("TranslationSource.initializePropertiesIfNeeded()Could not load TranslationResources.properties file.\nThe exception follows:\n" + lastException);
        }
    }
}

