/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.time.DayOfWeek;
import java.time.LocalDate;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestStart {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        frame.getContentPane().add(panel);
        DatePickerSettings dateSettings = new DatePickerSettings();
        dateSettings.setAllowEmptyDates(false);
        dateSettings.setAllowKeyboardEditing(false);
        DatePicker datePicker = new DatePicker(dateSettings);
        panel.add(datePicker);
        dateSettings.setVetoPolicy(new SampleDateVetoPolicy());
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundValidDate, Color.green);
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundInvalidDate, Color.blue);
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundVetoedDate, Color.orange);
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundDisallowedEmptyDate, Color.pink);
        frame.pack();
        frame.validate();
        int maxWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
        int maxHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
        frame.setSize(640, 480);
        frame.setLocation(maxWidth / 2, maxHeight / 2);
        frame.setVisible(true);
    }

    private static class SampleHighlightPolicy
    implements DateHighlightPolicy {
        private SampleHighlightPolicy() {
        }

        @Override
        public HighlightInformation getHighlightInformationOrNull(LocalDate date) {
            if (date.getDayOfMonth() == 25) {
                return new HighlightInformation(Color.red, null, "It's the 25th!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
                return new HighlightInformation(Color.orange, Color.yellow, "It's Saturday!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return new HighlightInformation(null, null, "It's Sunday!");
            }
            return null;
        }
    }

    private static class SampleDateVetoPolicy
    implements DateVetoPolicy {
        private SampleDateVetoPolicy() {
        }

        @Override
        public boolean isDateAllowed(LocalDate date) {
            if (date.getDayOfMonth() >= 7 && date.getDayOfMonth() <= 11) {
                return false;
            }
            return date.getDayOfWeek() != DayOfWeek.SATURDAY || date.getDayOfMonth() % 2 != 1;
        }
    }
}

