/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.CalendarSelectionListener;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.zinternaltools.CalendarSelectionEvent;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.time.LocalDate;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CalendarPanelTest {
    static JFrame frame = new JFrame();
    static JLabel informationLabel = new JLabel();
    static JPanel container = new JPanel();

    public static void main(String[] args) {
        CalendarPanelTest.initializeComponents();
        DatePickerSettings settings = new DatePickerSettings();
        CalendarPanel calendarPanel = new CalendarPanel(settings);
        calendarPanel.addCalendarSelectionListener(new SampleCalendarSelectionListener());
        container.add(calendarPanel);
        frame.setVisible(true);
    }

    private static void initializeComponents() {
        frame.setTitle("LGoodDatePicker Independent Calendar Panel Demo " + InternalUtilities.getProjectVersionString());
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        frame.getContentPane().add(mainPanel);
        container.setLayout(new GridBagLayout());
        mainPanel.add(informationLabel);
        mainPanel.add(new JLabel(" "));
        mainPanel.add(new JLabel(" "));
        mainPanel.add(container);
        informationLabel.setOpaque(true);
        informationLabel.setBackground(Color.white);
        informationLabel.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(2, 4, 2, 4)));
        informationLabel.setText("The selected date will be displayed here.");
        informationLabel.setAlignmentX(0.5f);
        frame.pack();
        frame.validate();
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
    }

    private static class SampleCalendarSelectionListener
    implements CalendarSelectionListener {
        private SampleCalendarSelectionListener() {
        }

        @Override
        public void selectionChanged(CalendarSelectionEvent event) {
            LocalDate oldDate = event.getOldDate();
            LocalDate newDate = event.getNewDate();
            String oldDateString = PickerUtilities.localDateToString(oldDate, "(null)");
            String newDateString = PickerUtilities.localDateToString(newDate, "(null)");
            String messageStart = "The selected date has changed from: ";
            String fullMessage = messageStart + oldDateString + " to: " + newDateString + ".";
            informationLabel.setText(fullMessage);
        }
    }
}

