/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ext.AbstractSwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.jaxrs.utils.ParameterUtils;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.properties.Property;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.reflections.util.Utils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringSwaggerExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(Annotation[] annotations, Class<?> cls, boolean isArray, Set<Class<?>> classesToSkip, Iterator<SwaggerExtension> chain) {
        String defaultValue = "";
        if (this.shouldIgnoreClass(cls)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof ModelAttribute) {
                parameters.addAll(this.extractParametersFromModelAttributeAnnotation(annotation, cls));
            } else {
                parameter = this.extractParameterFromAnnotation(annotation, defaultValue, cls, isArray);
            }
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private Parameter extractParameterFromAnnotation(Annotation annotation, String defaultValue, Class<?> cls, boolean isArray) {
        PathParameter parameter = null;
        if (annotation instanceof RequestParam) {
            Property schema;
            RequestParam param = (RequestParam)annotation;
            QueryParameter qp = new QueryParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                qp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                qp.setProperty(schema);
            }
            if (isArray || Collection.class.isAssignableFrom(cls) || cls.isArray()) {
                qp.setType("string");
            }
            qp.setRequired(param.required());
            parameter = qp;
        } else if (annotation instanceof PathVariable) {
            Property schema;
            PathVariable param = (PathVariable)annotation;
            PathParameter pp = new PathParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                pp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                pp.setProperty(schema);
            }
            parameter = pp;
        } else if (annotation instanceof RequestHeader) {
            RequestHeader param = (RequestHeader)annotation;
            HeaderParameter hp = new HeaderParameter().name(param.value());
            hp.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(cls);
            if (schema != null) {
                hp.setProperty(schema);
            }
            hp.setRequired(param.required());
            parameter = hp;
        } else if (annotation instanceof CookieValue) {
            Property schema;
            CookieValue param = (CookieValue)annotation;
            CookieParameter cp = new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                cp.setProperty(schema);
            }
            cp.setRequired(param.required());
            parameter = cp;
        }
        return parameter;
    }

    private List<Parameter> extractParametersFromModelAttributeAnnotation(Annotation annotation, Class beanClass) {
        if (!(annotation instanceof ModelAttribute)) {
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors((Class)beanClass)) {
            Type type;
            boolean isArray;
            Class<?> parameterClass;
            Annotation firstMethodParameterAnnotation;
            Annotation propertySetterApiParam;
            Method propertyDescriptorSetter = propertyDescriptor.getWriteMethod();
            if (propertyDescriptorSetter == null || !((propertySetterApiParam = AnnotationUtils.findAnnotation((Method)propertyDescriptorSetter, ApiParam.class)) instanceof ApiParam)) continue;
            Parameter propertySetterExtractedParameter = null;
            Annotation[][] methodAnnotations = propertyDescriptorSetter.getParameterAnnotations();
            if (methodAnnotations == null || methodAnnotations.length == 0) continue;
            String defaultValue = "";
            Annotation[] annotationArray = methodAnnotations[0];
            int n = annotationArray.length;
            for (int i = 0; i < n && !((propertySetterExtractedParameter = this.extractParameterFromAnnotation(firstMethodParameterAnnotation = annotationArray[i], defaultValue, parameterClass = propertyDescriptor.getPropertyType(), isArray = ParameterUtils.isMethodArgumentAnArray(parameterClass, (Type)(type = propertyDescriptorSetter.getGenericParameterTypes()[0])))) instanceof Parameter); ++i) {
            }
            if (!(propertySetterExtractedParameter instanceof Parameter)) {
                QueryParameter qp = new QueryParameter().name(propertyDescriptor.getDisplayName());
                Property schema = ModelConverters.getInstance().readAsProperty(propertyDescriptor.getPropertyType());
                if (schema != null) {
                    qp.setProperty(schema);
                }
                ApiParam methodApiParamAnnotation = (ApiParam)propertySetterApiParam;
                qp.setDescription(methodApiParamAnnotation.value());
                qp.setRequired(methodApiParamAnnotation.required());
                qp.setAccess(methodApiParamAnnotation.access());
                if (!Utils.isEmpty((String)methodApiParamAnnotation.name())) {
                    qp.setName(methodApiParamAnnotation.name());
                }
                parameters.add((Parameter)qp);
                continue;
            }
            parameters.add(propertySetterExtractedParameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = cls.getName().startsWith("org.springframework");
        return output;
    }
}

