/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ext.AbstractSwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.models.parameters.CookieParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class JaxrsParameterExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(Annotation[] annotations, Class<?> cls, boolean isArray, Set<Class<?>> classesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreClass(cls)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            parameter = JaxrsParameterExtension.getParameter(cls, parameter, annotation);
        }
        if (parameter != null) {
            parameters.add(parameter);
        }
        return parameters;
    }

    public static Parameter getParameter(Class<?> cls, Parameter parameter, Annotation annotation) {
        QueryParam param;
        String defaultValue = "";
        if (annotation instanceof DefaultValue) {
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            defaultValue = defaultValueAnnotation.value();
        }
        if (annotation instanceof QueryParam) {
            Property schema;
            param = (QueryParam)annotation;
            QueryParameter qp = new QueryParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                qp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                qp.setProperty(schema);
            }
            if (qp.getType().equals("ref") || qp.getType().equals("array")) {
                qp.setType("string");
            }
            parameter = qp;
        } else if (annotation instanceof PathParam) {
            Property schema;
            param = (PathParam)annotation;
            PathParameter pp = new PathParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                pp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                pp.setProperty(schema);
            }
            if (pp.getType().equals("ref") || pp.getType().equals("array")) {
                pp.setType("string");
            }
            parameter = pp;
        } else if (annotation instanceof HeaderParam) {
            param = (HeaderParam)annotation;
            HeaderParameter hp = new HeaderParameter().name(param.value());
            hp.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(cls);
            if (schema != null) {
                hp.setProperty(schema);
            }
            if (hp.getType().equals("ref") || hp.getType().equals("array")) {
                hp.setType("string");
            }
            parameter = hp;
        } else if (annotation instanceof CookieParam) {
            Property schema;
            param = (CookieParam)annotation;
            CookieParameter cp = new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                cp.setProperty(schema);
            }
            if (cp.getType().equals("ref") || cp.getType().equals("array")) {
                cp.setType("string");
            }
            parameter = cp;
        } else if (annotation instanceof FormParam) {
            Property schema;
            param = (FormParam)annotation;
            FormParameter fp = new FormParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                fp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(cls)) != null) {
                fp.setProperty(schema);
            }
            if (fp.getType().equals("ref") || fp.getType().equals("array")) {
                fp.setType("string");
            }
            parameter = fp;
        }
        return parameter;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = cls.getName().startsWith("javax.ws.rs");
        return output;
    }
}

