/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import smile.math.distance.Distance;

public class JaccardDistance<T>
implements Distance<T[]> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "Jaccard Distance";
    }

    @Override
    public double d(T[] a, T[] b) {
        HashSet<T> union = new HashSet<T>(Arrays.asList(b));
        Collections.addAll(union, a);
        HashSet intersection = new HashSet();
        Collections.addAll(intersection, a);
        intersection.retainAll(union);
        return 1.0 - (double)intersection.size() / (double)union.size();
    }

    public static <T> double d(Set<T> a, Set<T> b) {
        HashSet<T> union = new HashSet<T>(a);
        union.addAll(b);
        HashSet<T> intersection = new HashSet<T>(a);
        intersection.retainAll(b);
        return 1.0 - (double)intersection.size() / (double)union.size();
    }
}

