/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.distance.Distance;

public class DynamicTimeWarping<T>
implements Distance<T[]> {
    private static final long serialVersionUID = 1L;
    private final Distance<T> distance;
    private final double width;

    public DynamicTimeWarping(Distance<T> distance) {
        this(distance, 1.0);
    }

    public DynamicTimeWarping(Distance<T> distance, double radius) {
        if (radius < 0.0 || radius > 1.0) {
            throw new IllegalArgumentException("radius = " + radius);
        }
        this.distance = distance;
        this.width = radius;
    }

    public String toString() {
        return "Dynamic Time Warping";
    }

    @Override
    public double d(T[] x1, T[] x2) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        int radius = (int)Math.round(this.width * (double)Math.max(n1, n2));
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            int start = 1;
            int end = n2;
            if (radius > 0) {
                start = Math.max(1, i - radius);
                end = i + radius;
                if (end < n2) {
                    table[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = n2;
                }
            }
            table[1][start - 1] = Double.POSITIVE_INFINITY;
            for (int j = start; j <= end; ++j) {
                double cost = this.distance.d(x1[i - 1], x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(int[] x1, int[] x2) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            table[1][0] = Double.POSITIVE_INFINITY;
            for (int j = 1; j <= n2; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(int[] x1, int[] x2, int radius) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            int start = Math.max(1, i - radius);
            int end = Math.min(n2, i + radius);
            table[1][start - 1] = Double.POSITIVE_INFINITY;
            if (end < n2) {
                table[1][end + 1] = Double.POSITIVE_INFINITY;
            }
            for (int j = start; j <= end; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(float[] x1, float[] x2) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            table[1][0] = Double.POSITIVE_INFINITY;
            for (int j = 1; j <= n2; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(float[] x1, float[] x2, int radius) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            int start = Math.max(1, i - radius);
            int end = Math.min(n2, i + radius);
            table[1][start - 1] = Double.POSITIVE_INFINITY;
            if (end < n2) {
                table[1][end + 1] = Double.POSITIVE_INFINITY;
            }
            for (int j = start; j <= end; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(double[] x1, double[] x2) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            table[1][0] = Double.POSITIVE_INFINITY;
            for (int j = 1; j <= n2; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }

    public static double d(double[] x1, double[] x2, int radius) {
        int i;
        int n1 = x1.length;
        int n2 = x2.length;
        double[][] table = new double[2][n2 + 1];
        table[0][0] = 0.0;
        for (i = 1; i <= n2; ++i) {
            table[0][i] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i <= n1; ++i) {
            int start = Math.max(1, i - radius);
            int end = Math.min(n2, i + radius);
            table[1][start - 1] = Double.POSITIVE_INFINITY;
            if (end < n2) {
                table[1][end + 1] = Double.POSITIVE_INFINITY;
            }
            for (int j = start; j <= end; ++j) {
                double cost = Math.abs(x1[i - 1] - x2[j - 1]);
                double min = table[0][j - 1];
                if (min > table[0][j]) {
                    min = table[0][j];
                }
                if (min > table[1][j - 1]) {
                    min = table[1][j - 1];
                }
                table[1][j] = cost + min;
            }
            double[] swap = table[0];
            table[0] = table[1];
            table[1] = swap;
        }
        return table[0][n2];
    }
}

