/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.stream.Stream;

public interface CacheFiles {
    public static String dir() {
        String smile = File.separator + "smile";
        Object path = System.getenv("SMILE_CACHE");
        if (path == null) {
            String os = System.getProperty("os.name");
            String home = System.getProperty("user.home");
            if (os.startsWith("Windows")) {
                String localAppData = System.getenv("LocalAppData");
                path = localAppData + smile;
            } else {
                path = os.startsWith("Mac") ? home + "/Library/Caches" + smile : home + File.separator + ".cache" + smile;
            }
        }
        return path;
    }

    public static Path download(String url) throws IOException, URISyntaxException {
        return CacheFiles.download(url, false);
    }

    public static Path download(String url, boolean force) throws IOException, URISyntaxException {
        URI uri = new URI(url);
        Path path = Paths.get(CacheFiles.dir(), uri.getPath());
        File file = path.toFile();
        if ((force || !file.exists() || file.isDirectory()) && file.getParentFile().mkdirs()) {
            Files.copy(uri.toURL().openStream(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        return path;
    }

    public static void clean() throws IOException {
        try (Stream<Path> files = Files.walk(Paths.get(CacheFiles.dir(), new String[0]), new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

