/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import umich.ms.util.jaxb.JAXBCollection;

public class JaxbUtils {
    protected static volatile SoftReference<Cache> CACHE;

    private static synchronized <T> JAXBContext getContext(Class<T> type) throws JAXBException {
        Cache existingCache;
        SoftReference<Cache> existingCacheRef = CACHE;
        if (existingCacheRef != null && (existingCache = existingCacheRef.get()) != null && existingCache.type == type) {
            return existingCache.context;
        }
        Cache newCache = new Cache(type);
        CACHE = new SoftReference<Cache>(newCache);
        return newCache.context;
    }

    public static XMLStreamReader createXmlStreamReader(Path path, boolean namespaceAware) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(namespaceAware);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(new StreamSource(path.toFile()));
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    public static XMLStreamReader createXmlStreamReader(Path path) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(false);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(new StreamSource(path.toFile()));
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    public static XMLStreamReader createXmlStreamReader(InputStream is, boolean namespaceAware) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(namespaceAware);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    public static XMLStreamReader createXmlStreamReader(InputStream is) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(false);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    public static XMLStreamReader createXmlStreamReader(Reader reader, boolean namespaceAware) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(namespaceAware);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    public static XMLStreamReader createXmlStreamReader(Reader reader) throws JAXBException {
        XMLInputFactory xif = JaxbUtils.getXmlInputFactory(false);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        return xsr;
    }

    protected static XMLInputFactory getXmlInputFactory(boolean namespaceAware) throws JAXBException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        if (!namespaceAware) {
            if (!xif.isPropertySupported("javax.xml.stream.isNamespaceAware")) {
                throw new JAXBException("The XMLInputFactory on this system does not support non-namespace aware parsing. Look at the source of 'umich.ms.fileio.filetypes.pepxml.PepXmlParser#parse(Path) method as a reference to implement something else :)");
            }
            xif.setProperty("javax.xml.stream.isNamespaceAware", false);
        }
        return xif;
    }

    public static <T> T unmarshal(Class<T> clazz, XMLStreamReader xsr) throws JAXBException {
        JAXBContext jaxb = JaxbUtils.getContext(clazz);
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal(xsr, clazz);
        return (T)jaxbElement.getValue();
    }

    public static <T> T unmarshal(Class<T> clazz, XMLStreamReader xsr, Unmarshaller unmarshaller) throws JAXBException {
        JAXBElement jaxbElement = unmarshaller.unmarshal(xsr, clazz);
        return (T)jaxbElement.getValue();
    }

    public static <T> T unmarshal(Class<T> cl, String s) throws JAXBException {
        return JaxbUtils.unmarshal(cl, new StringReader(s));
    }

    public static <T> T unmarshal(Class<T> cl, File f) throws JAXBException {
        return JaxbUtils.unmarshal(cl, new StreamSource(f));
    }

    public static <T> T unmarshal(Class<T> cl, Reader r) throws JAXBException {
        return JaxbUtils.unmarshal(cl, new StreamSource(r));
    }

    public static <T> T unmarshal(Class<T> cl, InputStream s) throws JAXBException {
        return JaxbUtils.unmarshal(cl, new StreamSource(s));
    }

    public static <T> T unmarshal(Class<T> cl, Source s) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{cl});
        Unmarshaller u = ctx.createUnmarshaller();
        return (T)u.unmarshal(s, cl).getValue();
    }

    public static <T> List<T> unmarshalCollection(Class<T> cl, String s) throws JAXBException {
        return JaxbUtils.unmarshalCollection(cl, new StringReader(s));
    }

    public static <T> List<T> unmarshalCollection(Class<T> cl, Reader r) throws JAXBException {
        return JaxbUtils.unmarshalCollection(cl, new StreamSource(r));
    }

    public static <T> List<T> unmarshalCollection(Class<T> cl, InputStream s) throws JAXBException {
        return JaxbUtils.unmarshalCollection(cl, new StreamSource(s));
    }

    public static <T> List<T> unmarshalCollection(Class<T> cl, Source s) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{JAXBCollection.class, cl});
        Unmarshaller u = ctx.createUnmarshaller();
        JAXBCollection collection = (JAXBCollection)u.unmarshal(s, JAXBCollection.class).getValue();
        return collection.getItems();
    }

    public static <T> String marshal(T obj) throws JAXBException {
        StringWriter sw = new StringWriter();
        JaxbUtils.marshal(obj, sw);
        return sw.toString();
    }

    public static <T> void marshal(T obj, Writer wr) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller m = ctx.createMarshaller();
        m.marshal(obj, wr);
    }

    public static <T> void marshal(T obj, File f) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller m = ctx.createMarshaller();
        m.marshal(obj, f);
    }

    public static <T> void marshal(T obj, OutputStream s) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller m = ctx.createMarshaller();
        m.marshal(obj, s);
    }

    public static <T> String marshal(String rootName, Collection<T> c) throws JAXBException {
        StringWriter sw = new StringWriter();
        JaxbUtils.marshal(rootName, c, sw);
        return sw.toString();
    }

    public static <T> void marshal(String rootName, Collection<T> c, Writer w) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])JaxbUtils.findTypes(c));
        Marshaller m = ctx.createMarshaller();
        JAXBElement element = JaxbUtils.createCollectionElement(rootName, c);
        m.marshal((Object)element, w);
    }

    public static <T> void marshal(String rootName, Collection<T> c, File f) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])JaxbUtils.findTypes(c));
        Marshaller m = ctx.createMarshaller();
        JAXBElement element = JaxbUtils.createCollectionElement(rootName, c);
        m.marshal((Object)element, f);
    }

    public static <T> void marshal(String rootName, Collection<T> c, OutputStream s) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])JaxbUtils.findTypes(c));
        Marshaller m = ctx.createMarshaller();
        JAXBElement element = JaxbUtils.createCollectionElement(rootName, c);
        m.marshal((Object)element, s);
    }

    protected static <T> Class[] findTypes(Collection<T> c) {
        HashSet types = new HashSet();
        types.add(JAXBCollection.class);
        for (T o : c) {
            if (o == null) continue;
            types.add(o.getClass());
        }
        return types.toArray(new Class[0]);
    }

    protected static <T> JAXBElement createCollectionElement(String rootName, Collection<T> c) {
        JAXBCollection<T> collection = new JAXBCollection<T>(c);
        return new JAXBElement(new QName(rootName), JAXBCollection.class, collection);
    }

    protected static final class Cache {
        final Class<?> type;
        final JAXBContext context;

        public Cache(Class<?> type) throws JAXBException {
            this.type = type;
            this.context = JAXBContext.newInstance((Class[])new Class[]{type});
        }
    }
}

