/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import java.util.Iterator;
import java.util.Objects;

public abstract class StringUtils {
    private StringUtils() {
        throw new AssertionError((Object)"This class can't be instantiated");
    }

    public static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNullOrWhitespace(CharSequence s) {
        return StringUtils.isNullOrBlank(s);
    }

    public static boolean isNullOrBlank(CharSequence s) {
        return s == null || s.length() == 0 || StringUtils.isWhitespace(s);
    }

    public static boolean isWhitespace(CharSequence s) {
        int length = s.length();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            String result = Objects.toString(first);
            return result;
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            return Enum.valueOf(c, string.trim().toUpperCase());
        }
        return null;
    }
}

