/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.xmlbased;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import umich.ms.fileio.filetypes.xmlbased.XMLBasedIndexElement;

public interface IndexBuilder<T extends XMLBasedIndexElement>
extends Callable<Result<T>> {
    public Result<T> buildIndex(Info var1) throws Exception;

    public static class Result<T extends XMLBasedIndexElement> {
        private Info info;
        private List<T> indexElements;
        private List<T> closeTagLocs;
        private List<T> startTagLocs;

        public Result(Info info) {
            this.info = info;
            this.indexElements = new ArrayList<T>(32);
            this.closeTagLocs = new ArrayList<T>(32);
            this.startTagLocs = new ArrayList<T>(32);
        }

        public List<T> getIndexElements() {
            return this.indexElements;
        }

        public List<T> getCloseTagLocs() {
            return this.closeTagLocs;
        }

        public List<T> getStartTagLocs() {
            return this.startTagLocs;
        }

        public void addIndexElement(T indexElement) {
            this.indexElements.add(indexElement);
        }

        public void addCloseTag(T indexElement) {
            this.closeTagLocs.add(indexElement);
        }

        public void addStartTag(T indexElement) {
            this.startTagLocs.add(indexElement);
        }

        public Info getInfo() {
            return this.info;
        }
    }

    public static class Info {
        public static int counter = 0;
        public final long offsetInFile;
        public final int length;
        public final InputStream is;
        public final String asString;
        public final int index;

        public Info(long offsetInFile, int length, InputStream is, String asString) {
            this.offsetInFile = offsetInFile;
            this.length = length;
            this.is = is;
            this.asString = asString;
            this.index = counter++;
        }

        public String toString() {
            return "Info{index=" + this.index + ", offsetInFile=" + this.offsetInFile + ", length=" + this.length + ", offsetInFileEnd=" + (this.offsetInFile + (long)this.length) + '}';
        }
    }
}

