/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.nio.charset.StandardCharsets;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLUnexpectedEndOfDocumentException;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzml.MzmlVars;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.logging.LogHelper;
import umich.ms.util.OffsetLength;

public class MZMLIndexBuilder
implements IndexBuilder<MZMLIndexElement> {
    private ObjectPool<XMLStreamReaderImpl> pool;
    private IndexBuilder.Info info;
    private MzmlVars vars;

    public MZMLIndexBuilder(IndexBuilder.Info info, ObjectPool<XMLStreamReaderImpl> pool) {
        this.info = info;
        this.pool = pool;
        this.vars = new MzmlVars();
    }

    @Override
    public IndexBuilder.Result<MZMLIndexElement> call() throws Exception {
        return this.buildIndex(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexBuilder.Result<MZMLIndexElement> buildIndex(IndexBuilder.Info info) throws Exception {
        IndexBuilder.Result<MZMLIndexElement> result = new IndexBuilder.Result<MZMLIndexElement>(info);
        this.vars.reset();
        XMLStreamReaderImpl reader = this.pool == null ? new XMLStreamReaderImpl() : (XMLStreamReaderImpl)this.pool.borrowObject();
        try {
            int eventType;
            reader.setInput(info.is, StandardCharsets.UTF_8.name());
            LogHelper.setJavolutionLogLevelFatal();
            do {
                try {
                    eventType = reader.next();
                }
                catch (XMLStreamException e) {
                    if (e instanceof XMLUnexpectedEndTagException) {
                        eventType = reader.getEventType();
                    }
                    if (e instanceof XMLUnexpectedEndOfDocumentException) {
                        break;
                    }
                    throw new FileParsingException(e);
                }
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        Attributes attrs = reader.getAttributes();
                        if (!localName.contentEquals((CharSequence)MZMLMultiSpectraParser.TAG.SPECTRUM.name)) break;
                        if (this.vars.offsetLo != null) {
                            throw new FileParsingException("Nested spectrum tags not allowed in mzml.");
                        }
                        try {
                            this.vars.spectrumIndex = attrs.getValue((CharSequence)MZMLMultiSpectraParser.ATTR.SPECTRUM_INDEX.name).toInt();
                            this.vars.spectrumId = attrs.getValue((CharSequence)MZMLMultiSpectraParser.ATTR.SPECTRUM_ID.name).toString();
                            this.vars.offsetLo = reader.getLocation().getLastStartTagPos();
                            this.addAndFlush(result, info.offsetInFile);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new FileParsingException("Malformed scan number while building index", e);
                        }
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)MZMLMultiSpectraParser.TAG.SPECTRUM.name)) break;
                        this.vars.offsetHi = reader.getLocation().getTotalCharsRead();
                        this.addAndFlush(result, info.offsetInFile);
                    }
                }
            } while (eventType != 8);
        }
        finally {
            this.addAndFlush(result, info.offsetInFile);
            if (this.pool != null && reader != null) {
                this.pool.returnObject((Object)reader);
            }
        }
        return result;
    }

    private void addAndFlush(IndexBuilder.Result<MZMLIndexElement> result, long offsetInFile) throws FileParsingException {
        if (this.vars.offsetLo != null) {
            if (this.vars.spectrumIndex == null || this.vars.spectrumId == null) {
                long l = offsetInFile + this.vars.offsetLo;
                throw new IllegalStateException("When building index spectrum index or id were not found for offset: " + l);
            }
            if (this.vars.offsetHi != null) {
                long len = this.vars.offsetHi - this.vars.offsetLo;
                if (len < 0L) {
                    throw new FileParsingException("Calculated length was less than zero");
                }
                if (len > Integer.MAX_VALUE) {
                    throw new FileParsingException("Calculated length was larger than Integer.MAX_VALUE");
                }
                result.addIndexElement(new MZMLIndexElement(this.vars.spectrumIndex + 1, this.vars.spectrumIndex, this.vars.spectrumId, new OffsetLength(offsetInFile + this.vars.offsetLo, (int)len)));
            } else {
                result.addStartTag(new MZMLIndexElement(this.vars.spectrumIndex + 1, this.vars.spectrumIndex, this.vars.spectrumId, new OffsetLength(offsetInFile + this.vars.offsetLo, -1)));
            }
        } else if (this.vars.offsetHi != null) {
            result.addCloseTag(new MZMLIndexElement(-1, -1, "closing-tag", new OffsetLength(offsetInFile + this.vars.offsetHi, 0)));
        }
        this.vars.reset();
    }
}

