
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.pepxml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="database" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="min_num_enz_term" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "database_refresh_timestamp")
public class DatabaseRefreshTimestamp {

  @XmlAttribute(name = "database", required = true)
  protected String database;
  @XmlAttribute(name = "min_num_enz_term")
  @XmlJavaTypeAdapter(Adapter1.class)
  @XmlSchemaType(name = "nonNegativeInteger")
  protected Integer minNumEnzTerm;

  /**
   * Gets the value of the database property.
   *
   * @return possible object is {@link String }
   */
  public String getDatabase() {
    return database;
  }

  /**
   * Sets the value of the database property.
   *
   * @param value allowed object is {@link String }
   */
  public void setDatabase(String value) {
    this.database = value;
  }

  /**
   * Gets the value of the minNumEnzTerm property.
   *
   * @return possible object is {@link String }
   */
  public Integer getMinNumEnzTerm() {
    return minNumEnzTerm;
  }

  /**
   * Sets the value of the minNumEnzTerm property.
   *
   * @param value allowed object is {@link String }
   */
  public void setMinNumEnzTerm(Integer value) {
    this.minNumEnzTerm = value;
  }

}
