/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.thermo.raw.test;

import com4j.Holder;
import com4j.Variant;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umich.ms.fileio.filetypes.thermo.raw.ThermoRawFile;
import umich.ms.fileio.filetypes.thermo.raw.com4j.ClassFactory;
import umich.ms.fileio.filetypes.thermo.raw.com4j.IXRawfile;
import umich.ms.fileio.filetypes.thermo.raw.com4j.IXRawfile5;

public class ThermoTest {
    public static void main(String[] args) throws IOException {
        if (!ThermoRawFile.isPlatformSupported()) {
            throw new IllegalStateException("This platform is not supported.");
        }
        if (!ThermoRawFile.isThermoLibInstalled()) {
            throw new IllegalStateException("Thermo RawFileReader.dll is not installed. Either download an installer and install or register the dll using regsvr32.");
        }
        IXRawfile xRawfile = ClassFactory.createMSFileReader_XRawfile();
        IXRawfile5 xRawfile5 = (IXRawfile5)xRawfile.queryInterface(IXRawfile5.class);
        String directory = "C:\\data\\andrews\\xlink";
        Path dirPath = Paths.get(directory, new String[0]);
        DirectoryStream<Path> paths = Files.newDirectoryStream(dirPath, "*.raw");
        for (Path path : paths) {
            System.out.printf("Working with file: %s\n", path);
            xRawfile5.open(path.toString());
            Holder isThereMsData = new Holder();
            xRawfile5.isThereMSData((Holder<Integer>)isThereMsData);
            if ((Integer)isThereMsData.value != 1) {
                System.out.printf("There is no MS data in the file, skipping.\n", new Object[0]);
            }
            Holder numControllers = new Holder();
            xRawfile5.getNumberOfControllers((Holder<Integer>)numControllers);
            System.out.printf("Num controllers: %d\n", numControllers.value);
            ArrayList<Integer> goodControllers = new ArrayList<Integer>();
            for (int i = 0; i <= (Integer)numControllers.value; ++i) {
                Holder controllerType = new Holder();
                controllerType.value = null;
                xRawfile5.getControllerType(i, (Holder<Integer>)controllerType);
                System.out.printf("Controller number %d is of type %d.\n", i, controllerType.value);
                xRawfile5.setCurrentController((Integer)controllerType.value, i);
                Holder firstSpectrumNumber = new Holder();
                xRawfile5.getFirstSpectrumNumber((Holder<Integer>)firstSpectrumNumber);
                System.out.printf("It says the first spectrum number is: %d.\n", firstSpectrumNumber.value);
                Holder lastSpectrumNumber = new Holder();
                xRawfile5.getLastSpectrumNumber((Holder<Integer>)lastSpectrumNumber);
                System.out.printf("It says the last spectrum number is: %d.\n", lastSpectrumNumber.value);
                if ((Integer)firstSpectrumNumber.value > 0 && (Integer)lastSpectrumNumber.value > 0) {
                    Holder instModel = new Holder();
                    xRawfile5.getInstModel((Holder<String>)instModel);
                    Holder instName = new Holder();
                    xRawfile5.getInstName((Holder<String>)instName);
                    Holder instSerNum = new Holder();
                    xRawfile5.getInstSerialNumber((Holder<String>)instSerNum);
                    Holder instVerHard = new Holder();
                    xRawfile5.getInstHardwareVersion((Holder<String>)instVerHard);
                    Holder instVerSoft = new Holder();
                    xRawfile5.getInstSoftwareVersion((Holder<String>)instVerSoft);
                    Holder instId = new Holder();
                    xRawfile5.getInstrumentID((Holder<Integer>)instId);
                    System.out.printf("Instrument info:\n\tModel: %s\n\tName: %s\n\tSerial number: %s\n\tHardware ver: %s\n\tSoftware ver: %s\n\tID: %s\n", instModel.value, instName.value, instSerNum.value, instVerHard.value, instVerSoft.value, instId.value);
                }
                if ((Integer)firstSpectrumNumber.value <= 0 || (Integer)lastSpectrumNumber.value <= 0) continue;
                goodControllers.add(i);
            }
            if (goodControllers.isEmpty()) {
                throw new IllegalStateException("Could not find a single good MS controller.");
            }
            if (goodControllers.size() > 1) {
                throw new IllegalStateException("Found more than one good MS controller.");
            }
            Holder type = new Holder();
            int ctrlNum = (Integer)goodControllers.get(0);
            xRawfile5.getControllerType(ctrlNum, (Holder<Integer>)type);
            int ctrlTyp = (Integer)type.value;
            xRawfile5.setCurrentController(ctrlTyp, ctrlNum);
            Holder firstScanNum = new Holder();
            xRawfile5.getFirstSpectrumNumber((Holder<Integer>)firstScanNum);
            Holder lastScanNum = new Holder();
            xRawfile5.getLastSpectrumNumber((Holder<Integer>)lastScanNum);
            Variant filters = new Variant();
            Holder filtersSize = new Holder();
            xRawfile5.getFilters(filters, (Holder<Integer>)filtersSize);
            Object filtersArray = filters.get();
            System.out.printf("\tThe file has a total of %d filter lines\n", filtersSize.value);
            Pattern pattern = Pattern.compile("^([A-Z]+).*");
            String[] filtersStrArray = (String[])filtersArray;
            HashSet<String> uniqueInstIdentifiers = new HashSet<String>();
            for (String s : filtersStrArray) {
                Matcher matcher = pattern.matcher(s);
                if (!matcher.matches()) continue;
                uniqueInstIdentifiers.add(matcher.group(1));
            }
            if (!uniqueInstIdentifiers.isEmpty()) {
                System.out.printf("\tInstrument identifiers: %s\n", Arrays.toString(uniqueInstIdentifiers.toArray(new String[0])));
            }
            Holder scanNum = new Holder((Object)15);
            String filter = "";
            int cutoffType = 0;
            int cutoffValue = 0;
            Holder arrSize = new Holder();
            Holder cetroidWidth = new Holder();
            Variant masses = new Variant(Variant.Type.VT_EMPTY);
            Variant flags = new Variant(Variant.Type.VT_EMPTY);
            xRawfile5.getMassListFromScanNum((Holder<Integer>)scanNum, filter, cutoffType, cutoffValue, Integer.MAX_VALUE, 0, (Holder<Double>)cetroidWidth, masses, flags, (Holder<Integer>)arrSize);
            Variant.Type massesTypeAfterCall = masses.getType();
            Variant.Type flagsTypeAfterCall = flags.getType();
            Object massesRetrievedValue = masses.get();
            xRawfile5.close();
        }
    }
}

