
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.protxml.jaxb.standard;

import javax.xml.bind.annotation.XmlRegistry;


/**
 * This object contains factory methods for each Java content interface and Java element interface
 * generated in the umich.ms.fileio.filetypes.protxml.jaxb.standard package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation for XML content. The Java representation of
 * XML content can consist of schema derived interfaces and classes representing the binding of
 * schema type definitions, element declarations and model groups.  Factory methods for each of
 * these are provided in this class.
 */
@XmlRegistry
public class ObjectFactory {


  /**
   * Create a new ObjectFactory that can be used to create new instances of schema derived classes
   * for package: umich.ms.fileio.filetypes.protxml.jaxb.standard
   */
  public ObjectFactory() {
  }

  /**
   * Create an instance of {@link ASAPRatio }
   */
  public ASAPRatio createASAPRatio() {
    return new ASAPRatio();
  }

  /**
   * Create an instance of {@link ASAPSeq }
   */
  public ASAPSeq createASAPSeq() {
    return new ASAPSeq();
  }

  /**
   * Create an instance of {@link ASAPPvalueAnalysisSummary }
   */
  public ASAPPvalueAnalysisSummary createASAPPvalueAnalysisSummary() {
    return new ASAPPvalueAnalysisSummary();
  }

  /**
   * Create an instance of {@link ASAPRatioPvalue }
   */
  public ASAPRatioPvalue createASAPRatioPvalue() {
    return new ASAPRatioPvalue();
  }

  /**
   * Create an instance of {@link ProteinSummary }
   */
  public ProteinSummary createProteinSummary() {
    return new ProteinSummary();
  }

  /**
   * Create an instance of {@link ProteinSummaryHeader }
   */
  public ProteinSummaryHeader createProteinSummaryHeader() {
    return new ProteinSummaryHeader();
  }

  /**
   * Create an instance of {@link AnalysisSummary }
   */
  public AnalysisSummary createAnalysisSummary() {
    return new AnalysisSummary();
  }

  /**
   * Create an instance of {@link DatasetDerivation }
   */
  public DatasetDerivation createDatasetDerivation() {
    return new DatasetDerivation();
  }

  /**
   * Create an instance of {@link ProteinGroup }
   */
  public ProteinGroup createProteinGroup() {
    return new ProteinGroup();
  }

  /**
   * Create an instance of {@link ASAPPvalueAnalysisModel }
   */
  public ASAPPvalueAnalysisModel createASAPPvalueAnalysisModel() {
    return new ASAPPvalueAnalysisModel();
  }

  /**
   * Create an instance of {@link ASAPPoint }
   */
  public ASAPPoint createASAPPoint() {
    return new ASAPPoint();
  }

  /**
   * Create an instance of {@link StPeterQuant }
   */
  public StPeterQuant createStPeterQuant() {
    return new StPeterQuant();
  }

  /**
   * Create an instance of {@link StPeterQuantPeptide }
   */
  public StPeterQuantPeptide createStPeterQuantPeptide() {
    return new StPeterQuantPeptide();
  }

  /**
   * Create an instance of {@link ProteinprophetDetails }
   */
  public ProteinprophetDetails createProteinprophetDetails() {
    return new ProteinprophetDetails();
  }

  /**
   * Create an instance of {@link NspInformation }
   */
  public NspInformation createNspInformation() {
    return new NspInformation();
  }

  /**
   * Create an instance of {@link FpkmInformation }
   */
  public FpkmInformation createFpkmInformation() {
    return new FpkmInformation();
  }

  /**
   * Create an instance of {@link NiInformation }
   */
  public NiInformation createNiInformation() {
    return new NiInformation();
  }

  /**
   * Create an instance of {@link ProteinSummaryDataFilter }
   */
  public ProteinSummaryDataFilter createProteinSummaryDataFilter() {
    return new ProteinSummaryDataFilter();
  }

  /**
   * Create an instance of {@link ErrorPoint }
   */
  public ErrorPoint createErrorPoint() {
    return new ErrorPoint();
  }

  /**
   * Create an instance of {@link LibraResult }
   */
  public LibraResult createLibraResult() {
    return new LibraResult();
  }

  /**
   * Create an instance of {@link Intensity }
   */
  public Intensity createIntensity() {
    return new Intensity();
  }

  /**
   * Create an instance of {@link LibraSummary }
   */
  public LibraSummary createLibraSummary() {
    return new LibraSummary();
  }

  /**
   * Create an instance of {@link FragmentMasses }
   */
  public FragmentMasses createFragmentMasses() {
    return new FragmentMasses();
  }

  /**
   * Create an instance of {@link IsotopicContributions }
   */
  public IsotopicContributions createIsotopicContributions() {
    return new IsotopicContributions();
  }

  /**
   * Create an instance of {@link DecoyAnalysis }
   */
  public DecoyAnalysis createDecoyAnalysis() {
    return new DecoyAnalysis();
  }

  /**
   * Create an instance of {@link Point }
   */
  public Point createPoint() {
    return new Point();
  }

  /**
   * Create an instance of {@link StPeterAnalysisSummary }
   */
  public StPeterAnalysisSummary createStPeterAnalysisSummary() {
    return new StPeterAnalysisSummary();
  }

  /**
   * Create an instance of {@link XPressAnalysisSummary }
   */
  public XPressAnalysisSummary createXPressAnalysisSummary() {
    return new XPressAnalysisSummary();
  }

  /**
   * Create an instance of {@link DecoyAnalysisSummary }
   */
  public DecoyAnalysisSummary createDecoyAnalysisSummary() {
    return new DecoyAnalysisSummary();
  }

  /**
   * Create an instance of {@link ASAPProtAnalysisSummary }
   */
  public ASAPProtAnalysisSummary createASAPProtAnalysisSummary() {
    return new ASAPProtAnalysisSummary();
  }

  /**
   * Create an instance of {@link NameValueType }
   */
  public NameValueType createNameValueType() {
    return new NameValueType();
  }

  /**
   * Create an instance of {@link ModificationInfo }
   */
  public ModificationInfo createModificationInfo() {
    return new ModificationInfo();
  }

  /**
   * Create an instance of {@link ProteinAnnotation }
   */
  public ProteinAnnotation createProteinAnnotation() {
    return new ProteinAnnotation();
  }

  /**
   * Create an instance of {@link Mod }
   */
  public Mod createMod() {
    return new Mod();
  }

  /**
   * Create an instance of {@link ModAminoacidMass }
   */
  public ModAminoacidMass createModAminoacidMass() {
    return new ModAminoacidMass();
  }

  /**
   * Create an instance of {@link ContributingChannel }
   */
  public ContributingChannel createContributingChannel() {
    return new ContributingChannel();
  }

  /**
   * Create an instance of {@link AffectedChannel }
   */
  public AffectedChannel createAffectedChannel() {
    return new AffectedChannel();
  }

  /**
   * Create an instance of {@link NiDistribution }
   */
  public NiDistribution createNiDistribution() {
    return new NiDistribution();
  }

  /**
   * Create an instance of {@link FpkmDistribution }
   */
  public FpkmDistribution createFpkmDistribution() {
    return new FpkmDistribution();
  }

  /**
   * Create an instance of {@link NspDistribution }
   */
  public NspDistribution createNspDistribution() {
    return new NspDistribution();
  }

  /**
   * Create an instance of {@link Protein }
   */
  public Protein createProtein() {
    return new Protein();
  }

  /**
   * Create an instance of {@link AnalysisResult }
   */
  public AnalysisResult createAnalysisResult() {
    return new AnalysisResult();
  }

  /**
   * Create an instance of {@link IndistinguishableProtein }
   */
  public IndistinguishableProtein createIndistinguishableProtein() {
    return new IndistinguishableProtein();
  }

  /**
   * Create an instance of {@link Peptide }
   */
  public Peptide createPeptide() {
    return new Peptide();
  }

  /**
   * Create an instance of {@link PeptideParentProtein }
   */
  public PeptideParentProtein createPeptideParentProtein() {
    return new PeptideParentProtein();
  }

  /**
   * Create an instance of {@link IndistinguishablePeptide }
   */
  public IndistinguishablePeptide createIndistinguishablePeptide() {
    return new IndistinguishablePeptide();
  }

  /**
   * Create an instance of {@link DataFilter }
   */
  public DataFilter createDataFilter() {
    return new DataFilter();
  }

  /**
   * Create an instance of {@link ProgramDetails }
   */
  public ProgramDetails createProgramDetails() {
    return new ProgramDetails();
  }

  /**
   * Create an instance of {@link ASAPPeak }
   */
  public ASAPPeak createASAPPeak() {
    return new ASAPPeak();
  }

  /**
   * Create an instance of {@link ASAPDta }
   */
  public ASAPDta createASAPDta() {
    return new ASAPDta();
  }

}
