/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public abstract class EnumSetUserType<T extends Enum<T>>
implements UserType {
    private Class<T> typeClazz = null;
    private Class<? extends EnumSet> returnedType = null;

    public EnumSetUserType(Class<T> typeClazz) {
        this.typeClazz = typeClazz;
        this.returnedType = EnumSet.noneOf(typeClazz).getClass();
    }

    public Class returnedClass() {
        return this.returnedType;
    }

    public int[] sqlTypes() {
        return new int[]{-1};
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String name = rs.getString(names[0]);
        EnumSet<Object> result = null;
        if (!rs.wasNull()) {
            String[] values = name.split(",");
            LinkedHashSet<T> enumList = new LinkedHashSet<T>();
            for (String value : values) {
                if (value.isEmpty()) continue;
                enumList.add(Enum.valueOf(this.typeClazz, value));
            }
            result = enumList.isEmpty() ? EnumSet.noneOf(this.typeClazz) : EnumSet.copyOf(enumList);
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (null == value) {
            st.setNull(index, 12);
        } else {
            Set values = (Set)value;
            String sqlValue = "";
            if (!values.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (Enum val : values) {
                    buf.append(val.name()).append(",");
                }
                sqlValue = buf.substring(0, buf.length() - 1);
            }
            st.setString(index, sqlValue);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Enum)value;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (null == x || null == y) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

