/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.imagemap;

import gui.ava.html.exception.RenderException;
import gui.ava.html.imagemap.ElementBox;
import gui.ava.html.imagemap.HtmlImageMap;
import gui.ava.html.renderer.LayoutHolder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.LineBox;

public class HtmlImageMapImpl
implements HtmlImageMap {
    private static Set<String> searchedAttributes = HtmlImageMapImpl.stringSet("href", "onclick", "ondblclick", "onmousedown", "onmouseup");
    private static Set<String> allowedAttributes = HtmlImageMapImpl.stringSet("href", "target", "title", "class", "tabindex", "dir", "lang", "accesskey", "onblur", "onclick", "ondblclick", "onfocus", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onkeydown", "onkeypress", "onkeyup");
    private LayoutHolder layoutHolder;

    public HtmlImageMapImpl(LayoutHolder layoutHolder) {
        this.layoutHolder = layoutHolder;
    }

    @Override
    public String getImageMap(String mapName, String imageURL) {
        StringWriter writer = new StringWriter();
        this.saveImageMap(writer, mapName, imageURL);
        return writer.toString();
    }

    @Override
    public void saveImageMap(Writer writer, String mapName, String imageURL) {
        try {
            writer.append("<map name=\"").append(mapName).append("\">\n");
            for (Collection<ElementBox> boxes : this.getClickableBoxes().values()) {
                for (ElementBox elementBox : boxes) {
                    int x1 = elementBox.getLeft();
                    int y1 = elementBox.getTop();
                    int x2 = elementBox.getRight();
                    int y2 = elementBox.getBottom();
                    writer.append(String.format("<area coords=\"%s,%s,%s,%s\" shape=\"rect\"", x1, y1, x2, y2));
                    NamedNodeMap attributes = elementBox.getElement().getAttributes();
                    int l = attributes.getLength();
                    for (int i = 0; i < l; ++i) {
                        String lowerName;
                        Node node = attributes.item(i);
                        String name = node.getNodeName();
                        String value = node.getNodeValue();
                        if (name == null || value == null || !allowedAttributes.contains(lowerName = name.toLowerCase())) continue;
                        writer.append(" ").append(lowerName).append("=\"").append(value.replace("\"", "&quot;")).append("\"");
                    }
                    writer.append(">\n");
                }
            }
            writer.append("</map>\n");
        }
        catch (IOException e) {
            throw new RenderException("IOException while writing client-side image map.", e);
        }
    }

    @Override
    public String getImageMapDocument(String imageURL) {
        StringWriter writer = new StringWriter();
        this.saveImageMapDocument(writer, imageURL, true);
        return writer.toString();
    }

    @Override
    public void saveImageMapDocument(Writer writer, String imageURL, boolean closeWriter) {
        try {
            writer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
            writer.append("<html>\n<head><style>area {cursor: pointer;}</style></head>\n");
            writer.append("<body style=\"margin: 0; padding: 0; text-align: center;\">\n");
            this.saveImageMap(writer, "map", imageURL);
            writer.append("<img border=\"0\" usemap=\"#map\" src=\"");
            writer.append(imageURL);
            writer.append("\"/>\n");
            writer.append("</body>\n</html>");
        }
        catch (IOException e) {
            throw new RenderException("IOException while writing image map document.", e);
        }
        finally {
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public void saveImageMapDocument(File file, String imageURL) {
        try {
            this.saveImageMapDocument(new FileWriter(file), imageURL, true);
        }
        catch (IOException e) {
            throw new RenderException(String.format("IOException while writing image map document '%s'.", file.getAbsolutePath()), e);
        }
    }

    @Override
    public void saveImageMapDocument(String filename, String imageURL) {
        this.saveImageMapDocument(new File(filename), imageURL);
    }

    @Override
    public Map<Element, Collection<ElementBox>> getClickableBoxes() {
        Box rootBox = this.layoutHolder.getRootBox();
        HashMap<Element, Collection<ElementBox>> boxes = new HashMap<Element, Collection<ElementBox>>();
        this.addClickableElements((Styleable)rootBox, boxes, new HashSet<Styleable>());
        return boxes;
    }

    private void addClickableElements(Styleable styleable, HashMap<Element, Collection<ElementBox>> boxes, Set<Styleable> visited) {
        block8: {
            block9: {
                block7: {
                    if (styleable == null || visited.contains(styleable)) {
                        return;
                    }
                    visited.add(styleable);
                    this.addIfClickable(styleable, boxes);
                    if (styleable instanceof Box) {
                        for (Object child : ((Box)styleable).getChildren()) {
                            this.addClickableElements((Styleable)child, boxes, visited);
                        }
                    }
                    if (!(styleable instanceof InlineLayoutBox)) break block7;
                    for (Object child : ((InlineLayoutBox)styleable).getInlineChildren()) {
                        if (!(child instanceof Styleable)) continue;
                        this.addClickableElements((Styleable)child, boxes, visited);
                    }
                    break block8;
                }
                if (!(styleable instanceof BlockBox)) break block9;
                List content = ((BlockBox)styleable).getInlineContent();
                if (content == null) break block8;
                for (Styleable child : content) {
                    this.addClickableElements(child, boxes, visited);
                }
                break block8;
            }
            if (styleable instanceof LineBox) {
                for (Object child : ((LineBox)styleable).getNonFlowContent()) {
                    this.addClickableElements((Styleable)child, boxes, visited);
                }
            }
        }
    }

    private void addIfClickable(Styleable styleable, HashMap<Element, Collection<ElementBox>> boxes) {
        Element clickable = this.getClickableElement(styleable);
        if (clickable == null) {
            return;
        }
        ElementBox elementBox = this.createElementBox(styleable, clickable);
        if (elementBox == null || elementBox.isEmpty()) {
            return;
        }
        Collection<ElementBox> elementBoxes = boxes.get(clickable);
        if (elementBoxes == null) {
            elementBoxes = new ArrayList<ElementBox>();
            boxes.put(clickable, elementBoxes);
            elementBoxes.add(elementBox);
            return;
        }
        if (!elementBox.containedIn(elementBoxes)) {
            elementBoxes.add(elementBox);
        }
    }

    private ElementBox createElementBox(Styleable styleable, Element element) {
        if (styleable instanceof InlineLayoutBox) {
            InlineLayoutBox box = (InlineLayoutBox)styleable;
            int width = Math.max(box.getInlineWidth(), box.getWidth());
            return new ElementBox(element, box.getAbsX(), box.getAbsY(), width, box.getHeight());
        }
        if (styleable instanceof Box) {
            Box box = (Box)styleable;
            return new ElementBox(element, box.getAbsX(), box.getAbsY(), box.getWidth(), box.getHeight());
        }
        return null;
    }

    private Element getClickableElement(Styleable box) {
        Element element = box.getElement();
        while (element != null) {
            if (this.isClickable(element)) {
                return element;
            }
            Node parentNode = element.getParentNode();
            element = parentNode instanceof Element ? (Element)parentNode : null;
        }
        return null;
    }

    private boolean isClickable(Element element) {
        for (String attribute : searchedAttributes) {
            String value = element.getAttribute(attribute);
            if (!StringUtils.isNotBlank((String)value)) continue;
            return true;
        }
        return false;
    }

    private static HashSet<String> stringSet(String ... items) {
        return new HashSet<String>(Arrays.asList(items));
    }
}

