package com.franciaflex.faxtomail.ui.swing.content.demande.history;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class HistoryListUI extends AbstractToolbarPopupUI<com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel, HistoryListUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz08TQRR+LLRYwCAQEQUS0RhvU+OVg/xKA6SooZIQe3G6O20HZ3fGmVlZLsY/wT9B715MvHkyHjx78GL8F4zx4NX4Zrt0C67B2MNusu993/vmzff19TcoGQ1LBzRJiI4jy0NGtlf39++1DphvN5jxNVdWauj9hjzwmjAe9L8bC9ebdQevZvDqugyVjFg0gF6uw5ixR4KZLmPWwuJJhG9MtdEvLycq1sesfVFFrC9/fPdeBM9feQCJQnXuKFfPQuUnGamDxwML0zjpKa0KGnVQhuZRB/Wed9/WBTXmLg3ZE3gGo3UoK6qRzMK1fz9yypHiE2VhqssNVo/q+NrgVMiOhU1fhqStaeRz2hYsIW2aWBlSLkjMiTlEQcSXkUV+ErCQRgEjGQ3ZzOn2tpRKB5UtlEIZMGFh9T+oN3rvva0dx5FzjrRkcGRhSeoOOUAHPLZS9SgSsr3/gFvBgvs0GoTMUWup3w2Rfg3BDV9LIVyPhUtuv0kmYTuvOORkn6DSOydn6LMrxYPd0V33tMLbnz9x++grkvsqv/ihJpR0LBzpXPNPK+5iqWfCuVMmdIRp9dfszOd3X9/Wjp03jLMvFrYOBAcdobRUTNv0PJM928WWi+oOVctNqBgmMHVpqhYKhDWyMorDeVMOThycbFLTRYrS6Jf3H2YffRoGrwZjQtKgRl3/FlRsV+MWpAgSdWclVTRxeA6fF5w21BLShIdxuCsP12XsHO7dvpXgBhYKNtCX0ap8/DnTeLNyvAUPVV3+a3u+idJDKPNI8IilCczCVZi4cWVYHMg8REWxAgzW7BqjUY0LyzRtYVmGLbkmk8yLN13LhGs5VVhMn0tFOylZZ2kL83lmBsJL0moSO/gNB8jmZDlRZ/OPssgpxT+gUpsKU8iV+x8JfwPwoBiZrQUAAA==";
    private static final Log log = LogFactory.getLog(HistoryListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane attachmentBodyScrollPane;
    protected final HistoryListUIHandler handler = createHandler();
    protected JXList histories;
    protected HistoryListUI historyListDialog = this;
    protected DemandeUIModel model;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HistoryListUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI() {
        $initialize();
    }

    public HistoryListUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Window param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public HistoryListUIHandler getHandler() {
        return handler;
    }

    public JXList getHistories() {
        return histories;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(DemandeUIModel model) {
        DemandeUIModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(histories);
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(attachmentBodyScrollPane);
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.historyList.title"));
    }

    protected HistoryListUIHandler createHandler() {
        return new HistoryListUIHandler();
    }

    protected void createHistories() {
        $objectMap.put("histories", histories = new JXList());
        
        histories.setName("histories");
        histories.setEnabled(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToAttachmentBodyScrollPane();
        // late initializer
        historyListDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("historyListDialog", historyListDialog);
        createModel();
        createAttachmentBodyScrollPane();
        createHistories();
        // inline creation of historyListDialog
        setName("historyListDialog");
        
        $completeSetup();
        handler.afterInit(this);
    }

}