/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.LoadFolderEmailsAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.table.filter.AbstractTableFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.util.pagination.PaginationParameter;

public class DemandeListTableFilter
extends AbstractTableFilter<JXTable> {
    private static final Log log = LogFactory.getLog(DemandeListTableFilter.class);
    protected DemandeListUIHandler handler;

    public DemandeListTableFilter(JXTable table, DemandeListUIHandler handler) {
        super((JTable)table);
        this.handler = handler;
    }

    protected boolean execute(int col, Collection<Object> items) {
        EmailFilter emailFilter = ((DemandeListUIModel)((Object)this.handler.getModel())).getEmailFilter();
        String property = ((ColumnIdentifier)((JXTable)this.getTable()).getColumn(col).getIdentifier()).getPropertyName();
        boolean filtered = this.isFiltered(col);
        switch (property) {
            case "demandStatus": {
                emailFilter.setDemandStatus((Set<DemandStatus>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "receptionDate": {
                emailFilter.setReceptionDates((Set<Date>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "recipient": {
                emailFilter.setRecipients((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "sender": {
                emailFilter.setSenders((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "object": {
                emailFilter.setDemandObjects((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "clientCode": {
                emailFilter.setClientCodes((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "clientBrand": {
                emailFilter.setClientBrands((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "demandType": {
                emailFilter.setDemandTypes((Set<DemandType>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "ediError": {
                emailFilter.setEdiCodeNumbers((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "waitingState": {
                emailFilter.setWaitingStates((Set<WaitingState>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "takenBy": {
                emailFilter.setTakenBys((Set<FaxToMailUser>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "priority": {
                emailFilter.setPriorities((Set<Priority>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "projectReference": {
                emailFilter.setProjectReferences((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "companyReference": {
                emailFilter.setLocalReferences((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "reference": {
                emailFilter.setReferences((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "pfNb": {
                emailFilter.setProductsQuantities((Set<Long>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "savNb": {
                emailFilter.setSavQuantities((Set<Long>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "quotationNb": {
                emailFilter.setQuotationQuantities((Set<Long>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "lastAttachmentOpener": {
                emailFilter.setLastAttachmentOpeners((Set<FaxToMailUser>)(!filtered ? null : new HashSet<Object>(items)));
                break;
            }
            case "comment": {
                emailFilter.setComments((Set<String>)(!filtered ? null : new HashSet<Object>(items)));
            }
        }
        this.executeFilter();
        return true;
    }

    public void modelChanged(TableModel model) {
        this.fireFilterChange();
    }

    public Set<Object> distinctValuesForColumn(int i) {
        String[] properties;
        MailFolder selectedFolder = ((DemandeListUIModel)((Object)this.handler.getModel())).getSelectedFolder();
        if (selectedFolder == null) {
            return null;
        }
        JXTable dataTable = ((DemandeListUI)this.handler.getUI()).getDataTable();
        EmailService emailService = this.handler.getContext().newServiceContext().getEmailService();
        String property = ((ColumnIdentifier)dataTable.getColumn(i).getIdentifier()).getPropertyName();
        HashSet<Object> result = new HashSet<Object>();
        boolean sum = false;
        switch (property) {
            case "clientCode": {
                properties = new String[]{"client.code"};
                break;
            }
            case "clientBrand": {
                properties = new String[]{"client.brand"};
                break;
            }
            case "reference": {
                properties = new String[]{"email.companyReference", "rangeRow.commandNumber"};
                break;
            }
            case "pfNb": {
                properties = new String[]{"rangeRow.productQuantity"};
                sum = true;
                break;
            }
            case "savNb": {
                properties = new String[]{"rangeRow.savQuantity"};
                sum = true;
                break;
            }
            case "quotationNb": {
                properties = new String[]{"rangeRow.quotationQuantity"};
                sum = true;
                break;
            }
            case "attachment": 
            case "replies": 
            case "emailGroup": {
                return null;
            }
            default: {
                properties = new String[]{"email." + property};
            }
        }
        result.addAll(emailService.getDistinctValues(selectedFolder, properties, sum));
        if ("receptionDate".equals(property)) {
            HashSet<Date> filteredDates = new HashSet<Date>();
            if (log.isDebugEnabled()) {
                log.debug((Object)("result size " + result.size() + " " + result));
            }
            for (Object e : result) {
                if (e == null) continue;
                Date date = (Date)e;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(13, 0);
                cal.set(14, 0);
                filteredDates.add(cal.getTime());
            }
            result = new HashSet(filteredDates);
        }
        return result;
    }

    public String toString(Object obj) {
        Decorator<?> decorator;
        String s = null;
        if (obj != null && (decorator = this.handler.getDecorator(obj.getClass(), null)) != null) {
            s = decorator.toString(obj);
        }
        if (s == null) {
            s = JAXXUtil.getStringValue((Object)obj);
        }
        return s;
    }

    public void clear() {
        super.clear();
        ((DemandeListUIModel)((Object)this.handler.getModel())).getEmailFilter().clear();
        this.executeFilter();
    }

    protected void executeFilter() {
        FaxToMailUIContext context = this.handler.getContext();
        PaginationParameter currentPaginationParameter = context.getCurrentPaginationParameter();
        if (currentPaginationParameter != null) {
            ((DemandeListUIModel)((Object)this.handler.getModel())).setPaginationParameter(currentPaginationParameter);
            context.setCurrentPaginationParameter(null);
        } else {
            ((DemandeListUIModel)((Object)this.handler.getModel())).resetPaginationParameter();
        }
        LoadFolderEmailsAction loadFolderEmailsAction = (LoadFolderEmailsAction)context.getActionFactory().createLogicAction((AbstractApplicationUIHandler)this.handler, LoadFolderEmailsAction.class);
        if (context.isActionInProgress(null)) {
            context.getActionEngine().runFullInternalAction((AbstractApplicationAction)loadFolderEmailsAction);
        } else {
            context.getActionEngine().runAction((AbstractApplicationAction)loadFolderEmailsAction);
        }
    }
}

