/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.adapters.FloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorFloatIterator;

abstract class AbstractCollectionFloatCollection
implements FloatCollection {
    protected AbstractCollectionFloatCollection() {
    }

    public boolean add(float element) {
        return this.getCollection().add(new Float(element));
    }

    public boolean addAll(FloatCollection c) {
        return this.getCollection().addAll(FloatCollectionCollection.wrap(c));
    }

    public void clear() {
        this.getCollection().clear();
    }

    public boolean contains(float element) {
        return this.getCollection().contains(new Float(element));
    }

    public boolean containsAll(FloatCollection c) {
        return this.getCollection().containsAll(FloatCollectionCollection.wrap(c));
    }

    public String toString() {
        return this.getCollection().toString();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    public FloatIterator iterator() {
        return IteratorFloatIterator.wrap(this.getCollection().iterator());
    }

    public boolean removeElement(float element) {
        return this.getCollection().remove(new Float(element));
    }

    public boolean removeAll(FloatCollection c) {
        return this.getCollection().removeAll(FloatCollectionCollection.wrap(c));
    }

    public boolean retainAll(FloatCollection c) {
        return this.getCollection().retainAll(FloatCollectionCollection.wrap(c));
    }

    public int size() {
        return this.getCollection().size();
    }

    public float[] toArray() {
        Object[] src = this.getCollection().toArray();
        float[] dest = new float[src.length];
        for (int i = 0; i < src.length; ++i) {
            dest[i] = ((Number)src[i]).floatValue();
        }
        return dest;
    }

    public float[] toArray(float[] dest) {
        Object[] src = this.getCollection().toArray();
        if (dest.length < src.length) {
            dest = new float[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            dest[i] = ((Number)src[i]).floatValue();
        }
        return dest;
    }

    protected abstract Collection getCollection();
}

