package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: QuantitiesByRangeUIModel.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/demande/QuantitiesByRangeUIModel.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jdesktop.beans.AbstractBean;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;

/**
 * @author Kevin Morin (Code Lutin)
 *
 */
public class QuantitiesByRangeUIModel extends AbstractBean {

    public static final String PROPERTY_ROOT_FOLDER = "rootFolder";
    public static final String PROPERTY_RANGE_ROWS = "rangeRows";

    protected MailFolder rootFolder;

    protected List<RangeRowModel> rangeRows = new ArrayList<RangeRowModel>();

    public MailFolder getRootFolder() {
        return rootFolder;
    }

    public void setRootFolder(MailFolder rootFolder) {
        Object oldValue = getRootFolder();
        this.rootFolder = rootFolder;
        firePropertyChange(PROPERTY_ROOT_FOLDER, oldValue, rootFolder);
    }

    public List<RangeRowModel> getRangeRows() {
        return rangeRows;
    }

    public void setRangeRows(Collection<RangeRowModel> rangeRows) {
        this.rangeRows = new ArrayList<RangeRowModel>(rangeRows);
        firePropertyChange(PROPERTY_RANGE_ROWS, null, this.rangeRows);
    }
}
