/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandRepliesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandReplyItem;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.google.common.collect.Iterables;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;

public class DemandRepliesUIHandler
extends AbstractToolbarPopupHandler<DemandeUIModel, DemandRepliesUI> {
    private static final Log log = LogFactory.getLog(DemandRepliesUIHandler.class);

    @Override
    public void afterInit(DemandRepliesUI ui) {
        super.afterInit(ui);
        this.initTable(ui.getReplies());
        final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandRepliesUIHandler.this.updateTable();
            }
        };
        ((DemandRepliesUI)this.getUI()).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandeUIModel newModel;
                DemandeUIModel oldModel = (DemandeUIModel)evt.getOldValue();
                if (oldModel != null) {
                    oldModel.removePropertyChangeListener("replies", listener);
                }
                if ((newModel = (DemandeUIModel)evt.getNewValue()) != null) {
                    newModel.addPropertyChangeListener("replies", listener);
                }
                DemandRepliesUIHandler.this.updateTable();
            }
        });
    }

    protected void updateTable() {
        AbstractTableModel tableModel = (AbstractTableModel)((DemandRepliesUI)this.getUI()).getReplies().getModel();
        tableModel.fireTableDataChanged();
    }

    protected void initTable(JXTable table) {
        AbstractTableModel demandRepliesTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                DemandeUIModel model = (DemandeUIModel)DemandRepliesUIHandler.this.getModel();
                return model == null ? 0 : model.sizeReplies();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                DemandeUIModel model = (DemandeUIModel)DemandRepliesUIHandler.this.getModel();
                return model == null ? null : (Reply)Iterables.get(model.getReplies(), (int)rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        demandRepliesTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((DemandRepliesUI)DemandRepliesUIHandler.this.getUI()).pack();
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new DemandReplyItemRenderer());
        column.setCellEditor(new DemandReplyItemEditor());
        columnModel.addColumn(column);
        table.setModel((TableModel)demandRepliesTableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    public void onCloseUI() {
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void openReply(Reply reply) {
        this.closeEditor();
        try {
            ReplyFormUI dialogContent = new ReplyFormUI((FaxToMailUI)this.ui);
            MimeMessage message = new MimeMessage(null, (InputStream)new ByteArrayInputStream(reply.getEmailSource().getBytes()));
            ReplyFormUIModel replyModel = dialogContent.getModel();
            replyModel.setReadonly(true);
            replyModel.setSubject(message.getSubject());
            replyModel.setTo(message.getAllRecipients()[0].toString());
            replyModel.setFrom(message.getFrom()[0].toString());
            if (message.isMimeType("multipart/*")) {
                this.decomposeMultipartEmail((Part)message, replyModel, reply.getTopiaId());
            } else {
                String content = IOUtils.toString((InputStream)message.getInputStream());
                replyModel.setMessage(content);
            }
            this.openFrame(dialogContent, I18n.t((String)"faxtomail.reply.title", (Object[])new Object[]{((DemandeUIModel)this.getModel()).getSubject()}), new Dimension(800, 600));
        }
        catch (Exception e) {
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.demandReplies.error", (Object[])new Object[0]));
        }
    }

    protected void decomposeMultipartEmail(Part part, ReplyFormUIModel reply, String topiaId) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            BodyPart bp = mimeMultipart.getBodyPart(j);
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                String content = IOUtils.toString((InputStream)bp.getInputStream());
                reply.setMessage(content);
                continue;
            }
            if (bp.isMimeType("multipart/*")) {
                this.decomposeMultipartEmail((Part)bp, reply, topiaId);
                continue;
            }
            String fileName = bp.getFileName();
            if (fileName == null) {
                fileName = bp.getHeader("Content-ID")[0];
                fileName = fileName.replaceFirst("^<(.*)>$", "$1");
            }
            log.debug((Object)("FileName : " + fileName));
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            DataHandler dh = bp.getDataHandler();
            dh.writeTo((OutputStream)fos);
            AttachmentFileImpl attachment = new AttachmentFileImpl();
            attachment.setContent(fos.toByteArray());
            reply.addAttachment(attachment);
        }
    }

    protected class DemandReplyItemEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DemandReplyItem demandReplyItem;

        public DemandReplyItemEditor() {
            this.demandReplyItem = new DemandReplyItem(DemandRepliesUIHandler.this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Reply reply = (Reply)value;
            this.demandReplyItem.setReply(reply);
            return this.demandReplyItem;
        }

        @Override
        public Object getCellEditorValue() {
            return this.demandReplyItem.getReply();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    protected class DemandReplyItemRenderer
    extends DemandReplyItem
    implements TableCellRenderer {
        public DemandReplyItemRenderer() {
            super(DemandRepliesUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Reply reply = (Reply)value;
            this.setReply(reply);
            return this;
        }
    }
}

