/* The following code was generated by JFlex 1.4.1 on 18/07/12 16:06 */

/*
 * 02/05/2012
 *
 * JavaScriptTokenMaker.java - Parses a document into JavaScript tokens.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for JavaScript files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated JavaScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class JavaScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int E4X = 5;
  public static final int E4X_INTAG = 9;
  public static final int JS_MLC = 3;
  public static final int E4X_PI = 7;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 4;
  public static final int E4X_COMMENT = 6;
  public static final int E4X_DTD = 8;
  public static final int E4X_INATTR_SINGLE = 11;
  public static final int E4X_INATTR_DOUBLE = 10;
  public static final int YYINITIAL = 0;
  public static final int E4X_CDATA = 12;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\45\1\2\1\0\1\1\1\11\22\0\1\45\1\36\1\47"+
    "\1\12\1\15\1\35\1\40\1\57\2\56\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\41\1\46\1\31\1\32\1\34"+
    "\1\37\1\44\1\53\1\6\1\51\1\52\1\23\1\22\2\3\1\107"+
    "\2\3\1\21\1\3\1\106\5\3\1\54\3\3\1\20\2\3\1\50"+
    "\1\13\1\55\1\33\1\14\1\0\1\73\1\71\1\75\1\100\1\67"+
    "\1\64\1\103\1\60\1\65\1\3\1\74\1\66\1\43\1\77\1\76"+
    "\1\62\1\3\1\72\1\63\1\61\1\10\1\102\1\70\1\104\1\101"+
    "\1\105\1\26\1\33\1\26\1\42\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\12\0\2\1\1\0\1\2\1\3\1\4\1\5\2\6"+
    "\1\5\1\2\3\7\1\5\1\10\1\5\6\7\1\2"+
    "\1\11\1\12\22\5\1\1\1\13\1\14\1\15\1\1"+
    "\1\16\1\17\1\20\1\1\1\21\5\1\1\22\2\5"+
    "\1\23\1\24\1\25\1\26\1\1\1\27\5\1\1\30"+
    "\2\1\1\31\1\1\1\32\1\33\1\34\2\35\1\36"+
    "\1\37\1\40\1\41\1\1\1\42\3\1\1\2\1\43"+
    "\1\6\1\44\1\43\1\44\1\43\1\45\1\43\1\5"+
    "\2\0\1\46\1\47\2\7\2\0\1\50\1\7\1\51"+
    "\22\5\2\52\27\5\1\52\4\5\1\53\1\54\1\55"+
    "\1\56\4\0\1\57\1\24\1\60\1\61\1\25\5\0"+
    "\1\62\2\0\1\2\1\44\1\0\2\45\1\5\1\63"+
    "\1\0\26\5\1\25\1\5\1\64\35\5\6\0\1\65"+
    "\2\0\1\66\5\0\1\67\1\2\1\70\1\5\1\71"+
    "\21\5\1\25\1\5\1\72\1\73\16\5\1\0\1\1"+
    "\2\0\1\74\1\75\3\0\1\76\1\77\1\2\1\52"+
    "\10\5\1\52\15\5\5\0\1\2\14\5\1\100\3\5"+
    "\1\0\10\5\1\0\3\5\1\0\1\5\1\101";

  private static int [] zzUnpackAction() {
    int [] result = new int[382];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\110\0\220\0\330\0\u0120\0\u0168\0\u01b0\0\u01f8"+
    "\0\u0240\0\u0288\0\u02d0\0\u0318\0\u0360\0\u03a8\0\u03f0\0\u0438"+
    "\0\u0480\0\u04c8\0\u0510\0\u0558\0\u0438\0\u05a0\0\u05e8\0\u0630"+
    "\0\u0678\0\u0438\0\u0438\0\u06c0\0\u0708\0\u0750\0\u0798\0\u0438"+
    "\0\u07e0\0\u0828\0\u0438\0\u0438\0\u0870\0\u08b8\0\u0900\0\u0948"+
    "\0\u0990\0\u09d8\0\u0a20\0\u0a68\0\u0ab0\0\u0af8\0\u0b40\0\u0b88"+
    "\0\u0bd0\0\u0c18\0\u0c60\0\u0ca8\0\u0cf0\0\u0d38\0\u0d80\0\u0438"+
    "\0\u0dc8\0\u0438\0\u0e10\0\u0438\0\u0dc8\0\u0438\0\u0e58\0\u0438"+
    "\0\u0ea0\0\u0ee8\0\u0f30\0\u0f78\0\u0fc0\0\u0438\0\u1008\0\u1050"+
    "\0\u0438\0\u1098\0\u10e0\0\u0438\0\u1128\0\u0438\0\u1170\0\u11b8"+
    "\0\u1200\0\u1248\0\u1290\0\u0438\0\u12d8\0\u1320\0\u0438\0\u1368"+
    "\0\u0438\0\u0438\0\u0438\0\u13b0\0\u13f8\0\u1440\0\u0438\0\u0438"+
    "\0\u0438\0\u1488\0\u0438\0\u14d0\0\u1518\0\u1560\0\u15a8\0\u15f0"+
    "\0\u15f0\0\u15f0\0\u1638\0\u1680\0\u16c8\0\u1710\0\u1758\0\u17a0"+
    "\0\u17e8\0\u1830\0\u0438\0\u1878\0\u17e8\0\u18c0\0\u05e8\0\u18c0"+
    "\0\u0438\0\u1908\0\u1950\0\u1998\0\u19e0\0\u1a28\0\u1a70\0\u1ab8"+
    "\0\u1b00\0\u1b48\0\u1b90\0\u1bd8\0\u1c20\0\u1c68\0\u1cb0\0\u1cf8"+
    "\0\u1d40\0\u1d88\0\u1dd0\0\u1e18\0\u1e60\0\u0480\0\u1ea8\0\u1ef0"+
    "\0\u1f38\0\u1f80\0\u1fc8\0\u2010\0\u2058\0\u20a0\0\u20e8\0\u2130"+
    "\0\u2178\0\u21c0\0\u2208\0\u2250\0\u2298\0\u22e0\0\u2328\0\u2370"+
    "\0\u23b8\0\u2400\0\u2448\0\u2490\0\u24d8\0\u2520\0\u2568\0\u25b0"+
    "\0\u25f8\0\u2640\0\u2688\0\u0438\0\u26d0\0\u2718\0\u0438\0\u2760"+
    "\0\u27a8\0\u27f0\0\u2838\0\u2880\0\u28c8\0\u2910\0\u0438\0\u0438"+
    "\0\u2958\0\u29a0\0\u29e8\0\u2a30\0\u2a78\0\u0438\0\u2ac0\0\u2b08"+
    "\0\u2b50\0\u2b98\0\u2be0\0\u15f0\0\u2c28\0\u2c70\0\u2cb8\0\u2d00"+
    "\0\u2d48\0\u2d90\0\u2dd8\0\u2e20\0\u2e68\0\u2eb0\0\u2ef8\0\u2f40"+
    "\0\u2f88\0\u2fd0\0\u3018\0\u3060\0\u30a8\0\u30f0\0\u3138\0\u3180"+
    "\0\u31c8\0\u3210\0\u3258\0\u32a0\0\u32e8\0\u3330\0\u3378\0\u33c0"+
    "\0\u0480\0\u3408\0\u3450\0\u3498\0\u34e0\0\u3528\0\u3570\0\u35b8"+
    "\0\u3600\0\u3648\0\u3690\0\u36d8\0\u3720\0\u3768\0\u37b0\0\u37f8"+
    "\0\u3840\0\u3888\0\u38d0\0\u3918\0\u3960\0\u39a8\0\u39f0\0\u3a38"+
    "\0\u3a80\0\u3ac8\0\u3b10\0\u3b58\0\u3ba0\0\u3be8\0\u3c30\0\u3c78"+
    "\0\u3cc0\0\u3d08\0\u3d50\0\u3d98\0\u3de0\0\u3e28\0\u3e70\0\u0438"+
    "\0\u3eb8\0\u3f00\0\u3f48\0\u3f90\0\u3fd8\0\u0438\0\u4020\0\u0438"+
    "\0\u4068\0\u0480\0\u40b0\0\u40f8\0\u4140\0\u4188\0\u41d0\0\u4218"+
    "\0\u4260\0\u42a8\0\u42f0\0\u4338\0\u4380\0\u43c8\0\u4410\0\u4458"+
    "\0\u44a0\0\u44e8\0\u4530\0\u0480\0\u4578\0\u0480\0\u0480\0\u45c0"+
    "\0\u4608\0\u4650\0\u4698\0\u46e0\0\u4728\0\u4770\0\u47b8\0\u4800"+
    "\0\u4848\0\u4890\0\u48d8\0\u4920\0\u4968\0\u2718\0\u0438\0\u49b0"+
    "\0\u49f8\0\u4a40\0\u0438\0\u4a88\0\u4ad0\0\u4b18\0\u4b60\0\u0438"+
    "\0\u4ba8\0\u2d48\0\u4bf0\0\u4c38\0\u4c80\0\u4cc8\0\u4d10\0\u4d58"+
    "\0\u4da0\0\u4de8\0\u4e30\0\u4e78\0\u4ec0\0\u4f08\0\u4f50\0\u4f98"+
    "\0\u4fe0\0\u5028\0\u5070\0\u50b8\0\u5100\0\u5148\0\u5190\0\u51d8"+
    "\0\u5220\0\u4a40\0\u5268\0\u52b0\0\u4b60\0\u52f8\0\u5340\0\u5388"+
    "\0\u53d0\0\u5418\0\u5460\0\u54a8\0\u54f0\0\u5538\0\u5580\0\u55c8"+
    "\0\u5610\0\u5658\0\u0480\0\u56a0\0\u56e8\0\u5730\0\u5778\0\u57c0"+
    "\0\u5808\0\u5850\0\u5898\0\u58e0\0\u5928\0\u5970\0\u59b8\0\u5a00"+
    "\0\u5a48\0\u5a90\0\u5ad8\0\u5b20\0\u5b68\0\u0438";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[382];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\21\1\22"+
    "\1\24\1\25\2\16\2\21\1\26\1\27\4\21\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\27\1\37"+
    "\2\27\1\40\1\41\2\40\1\21\1\42\1\17\1\33"+
    "\1\43\1\32\4\21\2\32\1\44\1\21\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\21\1\60\1\21\1\61\1\62\1\21\1\63"+
    "\1\64\2\21\1\65\1\66\2\67\1\70\10\67\1\71"+
    "\33\67\1\72\40\67\2\73\1\74\10\73\1\75\43\73"+
    "\1\76\30\73\2\77\1\100\14\77\1\101\40\77\1\102"+
    "\3\77\1\103\3\77\1\104\17\77\2\105\1\106\55\105"+
    "\1\102\3\105\1\103\3\105\1\104\17\105\1\107\1\110"+
    "\1\111\26\107\1\112\6\107\1\113\4\107\1\17\1\114"+
    "\41\107\2\115\1\116\21\115\1\117\33\115\1\120\3\115"+
    "\1\121\3\115\1\122\17\115\2\123\1\124\34\123\1\125"+
    "\50\123\2\126\1\127\26\126\1\130\2\126\1\131\13\126"+
    "\1\132\4\126\1\133\32\126\1\134\1\135\1\0\13\134"+
    "\1\136\13\134\1\40\1\134\1\137\10\134\1\17\1\134"+
    "\1\140\7\134\1\141\30\134\47\142\1\143\40\142\57\144"+
    "\1\143\30\144\55\145\1\146\32\145\1\16\2\0\6\16"+
    "\1\0\4\16\2\0\4\16\17\0\2\16\4\0\4\16"+
    "\3\0\30\16\1\0\1\17\43\0\1\17\152\0\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\30\21\1\150"+
    "\2\0\1\150\2\22\1\150\1\22\1\150\1\0\4\150"+
    "\2\0\1\150\1\151\1\152\1\153\1\0\1\154\15\0"+
    "\2\150\4\0\1\150\1\152\2\150\3\0\4\150\1\152"+
    "\1\150\1\151\1\153\10\150\1\152\10\150\2\0\1\150"+
    "\1\155\1\156\1\150\1\156\1\150\1\0\4\150\2\0"+
    "\1\157\1\151\1\152\1\153\1\0\1\154\15\0\2\150"+
    "\4\0\1\150\1\152\2\150\3\0\4\150\1\152\1\150"+
    "\1\151\1\153\10\150\1\152\3\150\1\157\3\150\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\17\21\1\160"+
    "\10\21\13\161\1\162\2\161\1\163\1\164\12\161\1\165"+
    "\55\161\32\0\1\40\101\0\1\40\5\0\1\40\61\0"+
    "\2\154\1\0\1\154\130\0\1\40\1\0\1\166\106\0"+
    "\1\167\1\40\56\0\1\170\27\0\1\171\1\40\12\0"+
    "\1\170\74\0\1\40\1\0\1\172\105\0\1\40\5\0"+
    "\1\40\47\0\1\16\2\0\1\173\2\16\1\173\1\16"+
    "\1\173\1\0\4\16\2\0\4\173\17\0\1\173\1\16"+
    "\4\0\4\173\3\0\30\173\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\174\11\21\1\175\6\21\1\176"+
    "\6\21\1\16\2\0\5\21\1\177\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\12\21\1\200\1\201\14\21\1\16\2\0\5\21"+
    "\1\202\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\1\203\1\204\6\21"+
    "\1\205\10\21\1\206\6\21\1\16\2\0\5\21\1\207"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\5\21\1\210\1\211\4\21"+
    "\1\212\2\21\1\213\11\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\214\1\16"+
    "\4\0\4\21\3\0\3\21\1\215\1\216\12\21\1\217"+
    "\10\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\7\21\1\220\6\21\1\221\11\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\3\21\1\222\2\21\1\223"+
    "\4\21\1\224\3\21\1\225\2\21\1\226\1\21\1\227"+
    "\3\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\230\4\21\1\231\22\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\12\21\1\232\3\21\1\233\2\21"+
    "\1\234\6\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\7\21\1\235\20\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\11\21\1\236\16\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\1\237\5\21\1\240"+
    "\4\21\1\241\2\21\1\242\11\21\1\16\2\0\5\21"+
    "\1\243\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\7\21\1\244\3\21"+
    "\1\245\14\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\7\21\1\246\6\21\1\247\11\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\13\21\1\213\2\21"+
    "\1\250\11\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\16\21\1\251\11\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\13\21\1\252\14\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\17\21\1\253\10\21"+
    "\2\67\1\0\10\67\1\0\33\67\1\0\40\67\2\254"+
    "\1\0\5\254\1\255\73\254\1\256\3\254\2\73\1\0"+
    "\10\73\1\0\43\73\1\0\30\73\2\77\1\0\14\77"+
    "\1\0\40\77\1\0\3\77\1\0\3\77\1\0\17\77"+
    "\16\0\1\257\152\0\1\260\107\0\1\261\3\0\1\262"+
    "\112\0\1\263\17\0\2\105\1\0\55\105\1\0\3\105"+
    "\1\0\3\105\1\0\17\105\2\107\1\0\26\107\1\0"+
    "\6\107\1\0\4\107\2\0\42\107\1\110\1\0\26\107"+
    "\1\0\6\107\1\0\4\107\1\17\1\0\41\107\3\0"+
    "\1\264\2\0\1\264\1\0\1\264\3\0\1\264\1\0"+
    "\1\265\1\0\4\264\12\0\1\266\1\267\1\0\1\264"+
    "\1\0\1\264\5\0\4\264\3\0\30\264\45\113\1\0"+
    "\1\270\41\113\2\115\1\0\21\115\1\0\33\115\1\0"+
    "\3\115\1\0\3\115\1\0\17\115\24\0\1\271\144\0"+
    "\1\272\107\0\1\273\3\0\1\274\112\0\1\275\17\0"+
    "\2\123\1\0\34\123\1\0\50\123\34\0\1\276\53\0"+
    "\2\126\1\0\26\126\1\0\2\126\1\0\13\126\1\0"+
    "\4\126\1\0\32\126\36\0\1\277\51\0\2\134\1\0"+
    "\13\134\1\0\13\134\1\0\1\134\1\0\10\134\1\0"+
    "\1\134\1\0\7\134\1\0\31\134\1\135\1\0\13\134"+
    "\1\0\13\134\1\0\1\134\1\0\10\134\1\17\1\134"+
    "\1\0\7\134\1\0\30\134\34\0\1\137\53\0\47\142"+
    "\1\0\40\142\57\144\1\0\30\144\55\145\1\0\32\145"+
    "\55\0\1\300\32\0\1\16\2\0\5\16\1\301\1\0"+
    "\4\16\2\0\4\16\17\0\2\16\4\0\4\16\3\0"+
    "\30\16\1\150\2\0\6\150\1\0\4\150\2\0\4\150"+
    "\17\0\2\150\4\0\4\150\3\0\31\150\2\0\1\150"+
    "\2\302\1\150\1\302\1\150\1\0\4\150\2\0\4\150"+
    "\1\303\3\0\1\303\12\0\2\150\4\0\4\150\3\0"+
    "\31\150\2\0\1\150\2\154\1\150\1\154\1\150\1\0"+
    "\4\150\2\0\2\150\1\152\1\153\17\0\2\150\4\0"+
    "\1\150\1\152\2\150\3\0\4\150\1\152\2\150\1\153"+
    "\10\150\1\152\10\150\2\0\1\150\2\155\1\150\1\155"+
    "\1\150\1\0\4\150\2\0\2\150\1\152\1\153\1\0"+
    "\1\154\15\0\2\150\4\0\1\150\1\152\2\150\3\0"+
    "\4\150\1\152\2\150\1\153\10\150\1\152\10\150\2\0"+
    "\1\150\1\155\1\156\1\150\1\156\1\150\1\0\4\150"+
    "\2\0\1\150\1\304\1\152\1\153\1\0\1\154\15\0"+
    "\2\150\4\0\1\150\1\152\2\150\3\0\4\150\1\152"+
    "\1\150\1\304\1\153\10\150\1\152\10\150\2\0\1\150"+
    "\4\305\1\150\1\0\4\150\2\0\2\150\2\305\17\0"+
    "\2\150\4\0\3\305\1\150\3\0\4\150\1\305\2\150"+
    "\1\305\1\150\1\305\1\150\1\305\1\150\1\305\2\150"+
    "\1\305\7\150\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\7\21\1\306\20\21\13\161\1\162\2\161\1\307"+
    "\73\161\1\0\105\161\17\0\1\310\71\0\1\170\27\0"+
    "\1\171\13\0\1\170\74\0\1\40\1\0\1\27\53\0"+
    "\1\16\2\0\6\173\1\0\4\16\2\0\4\173\17\0"+
    "\1\173\1\16\4\0\4\173\3\0\30\173\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\5\21\1\311\4\21"+
    "\1\312\15\21\1\16\2\0\5\21\1\313\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\13\21\1\314\5\21\1\216\6\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\2\21\1\315"+
    "\25\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\11\21\1\316\16\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\5\21\1\317\10\21\1\320\11\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\12\21\1\321"+
    "\2\21\1\322\12\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\2\21\1\323\25\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\16\21\1\324\11\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\13\21\1\325"+
    "\14\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\5\21\1\326\22\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\17\21\1\327\10\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\17\21\1\330\10\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\17\21\1\331"+
    "\10\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\16\21\1\332\11\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\6\21\1\333\21\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\12\21\1\216\15\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\2\21\1\334"+
    "\25\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\2\21\1\335\1\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\26\21\1\336\1\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\1\21\1\337\1\21\1\340"+
    "\24\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\341\26\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\17\21\1\342\10\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\15\21\1\343\12\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\3\21\1\344"+
    "\24\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\15\21\1\345\12\21\1\16\2\0\5\21\1\346\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\30\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\13\21\1\347\14\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\1\21\1\350\1\351"+
    "\25\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\5\21\1\352\22\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\353\26\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\7\21\1\354\20\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\16\21\1\355"+
    "\11\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\356\26\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\357\26\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\3\21\1\360\24\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\13\21\1\361"+
    "\14\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\13\21\1\362\14\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\363\1\21\1\344\24\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\17\21\1\364"+
    "\10\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\6\21\1\365\21\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\10\21\1\216\17\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\1\21\1\366\26\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\4\21\1\367"+
    "\1\21\1\370\2\21\1\371\16\21\1\16\2\0\5\21"+
    "\1\372\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\30\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\5\21\1\373\1\374"+
    "\21\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\375\26\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\26\21\1\216\1\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\4\21\1\376\23\21\4\0"+
    "\4\377\12\0\2\377\25\0\3\377\10\0\1\377\2\0"+
    "\1\377\1\0\1\377\1\0\1\377\1\0\1\377\2\0"+
    "\1\377\13\0\4\u0100\12\0\2\u0100\25\0\3\u0100\10\0"+
    "\1\u0100\2\0\1\u0100\1\0\1\u0100\1\0\1\u0100\1\0"+
    "\1\u0100\2\0\1\u0100\70\0\1\u0101\110\0\1\u0102\113\0"+
    "\1\u0103\111\0\1\u0104\22\0\6\264\3\0\1\264\3\0"+
    "\6\264\13\0\1\264\1\0\1\264\5\0\4\264\3\0"+
    "\30\264\3\0\1\u0105\2\0\1\u0105\1\0\1\u0105\3\0"+
    "\1\u0105\3\0\4\u0105\15\0\1\u0105\1\0\1\u0105\5\0"+
    "\4\u0105\3\0\30\u0105\24\0\1\u0106\23\0\1\u0107\73\0"+
    "\1\u0108\134\0\1\u0109\110\0\1\u010a\113\0\1\u010b\111\0"+
    "\1\u010c\43\0\1\u010d\117\0\1\u010e\53\0\1\16\2\0"+
    "\1\16\4\u010f\1\16\1\0\4\16\2\0\2\16\2\u010f"+
    "\17\0\2\16\4\0\3\u010f\1\16\3\0\4\16\1\u010f"+
    "\2\16\1\u010f\1\16\1\u010f\1\16\1\u010f\1\16\1\u010f"+
    "\2\16\1\u010f\7\16\1\150\2\0\1\150\2\302\1\150"+
    "\1\302\1\150\1\0\4\150\2\0\2\150\1\152\1\150"+
    "\17\0\2\150\4\0\1\150\1\152\2\150\3\0\4\150"+
    "\1\152\13\150\1\152\7\150\4\0\2\302\1\0\1\302"+
    "\100\0\1\150\2\0\1\150\4\305\1\150\1\0\4\150"+
    "\2\0\1\150\1\304\2\305\17\0\2\150\4\0\3\305"+
    "\1\150\3\0\4\150\1\305\1\150\1\304\1\305\1\150"+
    "\1\305\1\150\1\305\1\150\1\305\2\150\1\305\7\150"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\3\21"+
    "\1\222\24\21\43\0\1\307\21\0\1\307\15\0\1\307"+
    "\22\0\1\u0110\71\0\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\3\21\1\216\24\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\16\21\1\u0111\11\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\7\21\1\u0112"+
    "\20\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\17\21\1\u0113\10\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\7\21\1\u0114\20\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\6\21\1\u0115\21\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\22\21\1\u0116"+
    "\5\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\u0117\26\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\3\21\1\u0118\24\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\14\21\1\u0119\13\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\7\21\1\213"+
    "\20\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\12\21\1\u011a\15\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\u0115\26\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\1\21\1\363\26\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\15\21\1\u011b"+
    "\12\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\15\21\1\u011c\12\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\13\21\1\u011d\14\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\13\21\1\u011a\14\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\3\21\1\313"+
    "\24\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\6\21\1\u011e\7\21\1\u011f\11\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\5\21\1\u0120\22\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\13\21\1\u0121"+
    "\14\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\7\21\1\u0122\20\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\u0123\26\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\23\21\1\u0124\4\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\13\21\1\u0125"+
    "\14\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\7\21\1\216\20\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\u0126\27\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\216\1\16"+
    "\4\0\4\21\3\0\30\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\6\21\1\u0127\21\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\7\21\1\u0128\20\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\16\21"+
    "\1\u011f\11\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\6\21\1\344\21\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\216\27\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\13\21\1\u0129\14\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\6\21\1\u012a"+
    "\21\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\7\21\1\u0124\20\21\1\16\2\0\5\21\1\u012b\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\30\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\21\1\u012c\26\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\12\21\1\u0124\15\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\3\21"+
    "\1\311\24\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\15\21\1\353\12\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\21\1\u012d\1\21\1\u012e\24\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\6\21"+
    "\1\216\21\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\5\21\1\u012f\22\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\13\21\1\u0130\14\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\7\21\1\u0131\20\21"+
    "\1\16\2\0\5\21\1\u0132\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\30\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\11\21\1\u0133\16\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\20\21\1\216\7\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\13\21\1\u0134\14\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\16\21\1\216"+
    "\11\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\5\21\1\u0135\22\21\4\0\4\u0136\12\0\2\u0136\25\0"+
    "\3\u0136\10\0\1\u0136\2\0\1\u0136\1\0\1\u0136\1\0"+
    "\1\u0136\1\0\1\u0136\2\0\1\u0136\13\0\4\u0137\12\0"+
    "\2\u0137\25\0\3\u0137\10\0\1\u0137\2\0\1\u0137\1\0"+
    "\1\u0137\1\0\1\u0137\1\0\1\u0137\2\0\1\u0137\71\0"+
    "\1\u0138\66\0\1\u0139\135\0\1\u0102\45\0\1\u013a\65\0"+
    "\6\u0105\3\0\1\u0105\3\0\6\u0105\13\0\1\u0105\1\0"+
    "\1\u0105\5\0\4\u0105\3\0\30\u0105\24\0\1\u013b\134\0"+
    "\1\u013c\120\0\1\u013d\66\0\1\u013e\135\0\1\u010a\45\0"+
    "\1\u013f\106\0\1\u0140\63\0\1\16\2\0\1\16\4\u0141"+
    "\1\16\1\0\4\16\2\0\2\16\2\u0141\17\0\2\16"+
    "\4\0\3\u0141\1\16\3\0\4\16\1\u0141\2\16\1\u0141"+
    "\1\16\1\u0141\1\16\1\u0141\1\16\1\u0141\2\16\1\u0141"+
    "\10\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\10\21"+
    "\1\u0142\17\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\3\21\1\u0143\24\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\16\21\1\u0144\11\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\5\21\1\u0145\22\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\13\21"+
    "\1\u0131\14\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\7\21\1\u0146\20\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\7\21\1\u0147\20\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\13\21\1\u0148\14\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\1\21"+
    "\1\u0124\26\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\1\u0149\27\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\1\21\1\u014a\26\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\6\21\1\u014b\21\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\7\21\1\u014c"+
    "\20\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\12\21\1\u012e\15\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\17\21\1\u014d\10\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\26\21\1\u0127\1\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\12\21\1\u014e"+
    "\15\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\13\21\1\u014f\14\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\2\21\1\u0150\25\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\17\21\1\u0151\10\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\14\21\1\216"+
    "\13\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\7\21\1\u0152\20\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\12\21\1\u0153\15\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\12\21\1\u0154\15\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\5\21\1\u0155"+
    "\22\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\216\26\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\22\21\1\344\5\21\1\16\2\0\5\21"+
    "\1\u0156\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\30\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\1\21\1\344\26\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\23\21"+
    "\1\u0157\4\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\6\21\1\356\21\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\21\1\230\26\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\17\21\1\u0158\10\21"+
    "\41\0\1\u0139\21\0\1\u0102\42\0\1\u0159\74\0\6\u013a"+
    "\1\0\1\u015a\1\0\1\u015a\2\u013a\1\u015a\4\u013a\2\u015a"+
    "\1\0\2\u015a\1\0\1\u015a\2\0\6\u015a\1\u013a\1\u015a"+
    "\1\0\1\u015a\1\0\1\u015a\4\u013a\3\u015a\30\u013a\52\0"+
    "\1\u015b\76\0\1\u013e\21\0\1\u010a\42\0\1\u015c\74\0"+
    "\6\u013f\1\0\1\u015d\1\0\1\u015d\2\u013f\1\u015d\4\u013f"+
    "\2\u015d\1\0\2\u015d\1\0\1\u015d\2\0\6\u015d\1\u013f"+
    "\1\u015d\1\0\1\u015d\1\0\1\u015d\4\u013f\3\u015d\30\u013f"+
    "\1\16\2\0\1\16\4\u015e\1\16\1\0\4\16\2\0"+
    "\2\16\2\u015e\17\0\2\16\4\0\3\u015e\1\16\3\0"+
    "\4\16\1\u015e\2\16\1\u015e\1\16\1\u015e\1\16\1\u015e"+
    "\1\16\1\u015e\2\16\1\u015e\10\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\5\21\1\u015f\22\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\4\21\1\216\23\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\15\21"+
    "\1\216\12\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\15\21\1\u0160\12\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\2\21\1\u0161\1\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\27\21\1\u0162\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\23\21\1\344"+
    "\4\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\12\21\1\u0163\15\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\5\21\1\u0164\22\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\6\21\1\u0165\21\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\u0166\1\16\4\0\4\21\3\0\30\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\5\21\1\u0167"+
    "\22\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\4\21\1\u0168\23\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\17\21\1\u0169\10\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\7\21\1\u0127\20\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\20\21\1\311"+
    "\7\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\13\21\1\u016a\14\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\17\21\1\u016b\10\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\13\21\1\u016c\14\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\17\21\1\u016d"+
    "\10\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\6\21\1\u012e\21\21\1\16\2\0\6\21\1\0\1\16"+
    "\1\147\2\21\2\0\4\21\17\0\1\21\1\16\4\0"+
    "\4\21\3\0\23\21\1\323\4\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\5\21\1\u016e\22\21\16\0"+
    "\1\u013a\144\0\1\u016f\52\0\1\u013f\71\0\1\16\2\0"+
    "\1\16\4\21\1\16\1\0\4\16\2\0\2\16\2\21"+
    "\17\0\2\16\4\0\3\21\1\16\3\0\4\16\1\21"+
    "\2\16\1\21\1\16\1\21\1\16\1\21\1\16\1\21"+
    "\2\16\1\21\10\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\7\21\1\u0170\20\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\1\21\1\u0171\26\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\6\21\1\u0172\21\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\17\21"+
    "\1\u0173\10\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\16\21\1\u0174\11\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\16\21\1\u0175\11\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\21\21\1\216\6\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\7\21"+
    "\1\u0176\20\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\1\21\1\u0150\26\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\13\21\1\u0177\14\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\15\21\1\315\12\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\17\21"+
    "\1\u0124\10\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\15\21\1\u012e\12\21\1\16\2\0\5\21\1\344"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\30\21\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\1\21\1\u0165\26\21\54\0"+
    "\1\u0178\33\0\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\17\21\1\u012e\10\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\7\21\1\373\20\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\16\21\1\u0179\11\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\1\21"+
    "\1\u0127\26\21\1\16\2\0\6\21\1\0\1\16\1\147"+
    "\2\21\2\0\4\21\17\0\1\21\1\16\4\0\4\21"+
    "\3\0\17\21\1\u017a\10\21\1\16\2\0\6\21\1\0"+
    "\1\16\1\147\2\21\2\0\4\21\17\0\1\21\1\16"+
    "\4\0\4\21\3\0\17\21\1\216\10\21\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\17\21\1\u017b\10\21"+
    "\1\16\2\0\6\21\1\0\1\16\1\147\2\21\2\0"+
    "\4\21\17\0\1\21\1\16\4\0\4\21\3\0\15\21"+
    "\1\344\12\21\53\0\1\u017c\34\0\1\16\2\0\6\21"+
    "\1\0\1\16\1\147\2\21\2\0\4\21\17\0\1\21"+
    "\1\16\4\0\4\21\3\0\13\21\1\u0173\14\21\1\16"+
    "\2\0\6\21\1\0\1\16\1\147\2\21\2\0\4\21"+
    "\17\0\1\21\1\16\4\0\4\21\3\0\5\21\1\u017d"+
    "\22\21\1\16\2\0\6\21\1\0\1\16\1\147\2\21"+
    "\2\0\4\21\17\0\1\21\1\16\4\0\4\21\3\0"+
    "\1\21\1\311\26\21\50\0\1\u017e\37\0\1\16\2\0"+
    "\6\21\1\0\1\16\1\147\2\21\2\0\4\21\17\0"+
    "\1\21\1\16\4\0\4\21\3\0\25\21\1\u0171\2\21";

  private static int [] zzUnpackTrans() {
    int [] result = new int[23472];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\12\0\2\1\1\0\2\1\1\11\4\1\1\11\4\1"+
    "\2\11\4\1\1\11\2\1\2\11\23\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\5\1"+
    "\1\11\2\1\1\11\2\1\1\11\1\1\1\11\5\1"+
    "\1\11\2\1\1\11\1\1\3\11\3\1\3\11\1\1"+
    "\1\11\15\1\2\0\1\11\3\1\2\0\1\11\62\1"+
    "\1\11\2\1\1\11\4\0\3\1\2\11\5\0\1\11"+
    "\2\0\2\1\1\0\4\1\1\0\66\1\6\0\1\1"+
    "\2\0\1\11\5\0\1\11\1\1\1\11\45\1\1\0"+
    "\1\11\2\0\1\1\1\11\3\0\1\1\1\11\30\1"+
    "\5\0\21\1\1\0\10\1\1\0\3\1\1\0\1\1"+
    "\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[382];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	private static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_INVALID	= -9;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_VALID		= -10;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_INVALID	= -11;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_VALID		= -12;

	private static final int INTERNAL_E4X = -13;

	private static final int INTERNAL_E4X_INTAG = -14;

	private static final int INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION = -15;

	private static final int INTERNAL_IN_E4X_COMMENT = -16;

	private static final int INTERNAL_E4X_DTD = -17;

	private static final int INTERNAL_E4X_DTD_INTERNAL = -18;

	private static final int INTERNAL_E4X_ATTR_SINGLE = -19;

	private static final int INTERNAL_E4X_ATTR_DOUBLE = -20;

	private static final int INTERNAL_E4X_MARKUP_CDATA = -21;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * Whether we're in an internal DTD.  Only valid if in an e4x DTD.
	 */
	private boolean e4x_inInternalDtd;

	/**
	 * The previous e4x state.  Only valid if in an e4x state.
	 */
	private int e4x_prevState;

	/**
	 * The version of JavaScript being highlighted.
	 */
	private static String jsVersion;

	/**
	 * Whether e4x is being highlighted.
	 */
	private static boolean e4xSupported;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Language state set on E4X tokens.
	 */
	private static final int LANG_INDEX_E4X = 1;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public JavaScriptTokenMaker() {
		super();
	}


	static {
		jsVersion = "1.0";
		e4xSupported = true;
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the JavaScript version being highlighted.
	 *
	 * @return Supported JavaScript version.
	 * @see #isJavaScriptCompatible(String)
	 */
	public static String getJavaScriptVersion() {
		return jsVersion;
	}


	/**
	 * {@inheritDoc}
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		e4x_prevState = YYINITIAL;
		e4x_inInternalDtd = false;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			case INTERNAL_E4X:
				state = E4X;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_INTAG:
				state = E4X_INTAG;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION:
				state = E4X_PI;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD:
				state = E4X_DTD;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD_INTERNAL:
				state = E4X_DTD;
				e4x_inInternalDtd = true;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_SINGLE:
				state = E4X_INATTR_SINGLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_DOUBLE:
				state = E4X_INATTR_DOUBLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_CDATA:
				state = E4X_CDATA;
				languageIndex = LANG_INDEX_E4X;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_E4X_COMMENT - prevState
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_IN_E4X_COMMENT:
							state = E4X_COMMENT;
							break;
					}
					e4x_prevState = -initialTokenType&0xff;
					languageIndex = LANG_INDEX_E4X;
				}
				else { // Shouldn't happen
					state = Token.NULL;
				}
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Returns whether e4x is being highlighted.
	 *
	 * @return Whether e4x is being highlighted.
	 * @see #setE4xSupported(boolean)
	 */
	public static boolean isE4xSupported() {
		return e4xSupported;
	}


	/**
	 * Returns whether features for a specific JS version should be honored
	 * while highlighting.
	 * 
	 * @param version JavaScript version required 
	 * @return Whether the JavaScript version is the same or greater than
	 *         version required. 
	 */
	public static boolean isJavaScriptCompatible(String version) {
		return jsVersion.compareTo(version) >= 0;
	}


	/**
	 * Sets whether e4x should be highlighted.  A repaint should be forced on
	 * all <code>RSyntaxTextArea</code>s editing JavaScript if this property
	 * is changed to see the difference.
	 *
	 * @param supported Whether e4x should be highlighted.
	 * @see #isE4xSupported()
	 */
	public static void setE4xSupported(boolean supported) {
		e4xSupported = supported;
	}


	/**
	 * Set the supported JavaScript version because some keywords were
	 * introduced on or after this version.
	 *
	 * @param javaScriptVersion The version of JavaScript to support, such as
	 *        "<code>1.5</code>" or "<code>1.6</code>".
	 * @see #isJavaScriptCompatible(String)
	 * @see #getJavaScriptVersion()
	 */
	public static void setJavaScriptVersion(String javaScriptVersion) {
		jsVersion = javaScriptVersion;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 66: break;
        case 5: 
          { addToken(Token.IDENTIFIER);
          }
        case 67: break;
        case 57: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 68: break;
        case 24: 
          { addToken(start,zzStartRead-1, INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
          }
        case 69: break;
        case 43: 
          { /* Skip all escaped chars. */
          }
        case 70: break;
        case 45: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 71: break;
        case 35: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 72: break;
        case 26: 
          { if (!e4x_inInternalDtd) { yybegin(E4X); addToken(start,zzStartRead, Token.FUNCTION); }
          }
        case 73: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 74: break;
        case 59: 
          { addToken(Token.FUNCTION);
          }
        case 75: break;
        case 28: 
          { e4x_inInternalDtd = false;
          }
        case 76: break;
        case 49: 
          { start = zzMarkedPos-2; yybegin(E4X_PI);
          }
        case 77: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 78: break;
        case 58: 
          { if(e4xSupported){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 79: break;
        case 39: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 80: break;
        case 13: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 81: break;
        case 51: 
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 82: break;
        case 47: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 83: break;
        case 16: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 84: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 85: break;
        case 38: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 86: break;
        case 54: 
          { int temp = zzMarkedPos; addToken(start,zzStartRead+2, Token.COMMENT_MULTILINE); start = temp; yybegin(e4x_prevState);
          }
        case 87: break;
        case 41: 
          { addToken(isE4xSupported() ? Token.MARKUP_TAG_ATTRIBUTE : Token.ERROR_IDENTIFIER);
          }
        case 88: break;
        case 37: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 89: break;
        case 55: 
          { int temp=zzStartRead; yybegin(E4X); addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addToken(temp,zzMarkedPos-1, Token.DATA_TYPE);
          }
        case 90: break;
        case 27: 
          { e4x_inInternalDtd = true;
          }
        case 91: break;
        case 30: 
          { addToken(Token.MARKUP_TAG_DELIMITER); /* Not valid but we'll still accept it */
          }
        case 92: break;
        case 12: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 93: break;
        case 3: 
          { addToken(Token.WHITESPACE);
          }
        case 94: break;
        case 46: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 95: break;
        case 21: 
          { addToken(Token.DATA_TYPE);
          }
        case 96: break;
        case 61: 
          { start = zzStartRead; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 97: break;
        case 65: 
          { addToken(Token.DATA_TYPE); start = zzMarkedPos; yybegin(E4X_CDATA);
          }
        case 98: break;
        case 48: 
          { start = zzMarkedPos-2; e4x_inInternalDtd = false; yybegin(E4X_DTD);
          }
        case 99: break;
        case 32: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_DOUBLE);
          }
        case 100: break;
        case 15: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 101: break;
        case 6: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 102: break;
        case 50: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.MARKUP_PROCESSING_INSTRUCTION);
          }
        case 103: break;
        case 29: 
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 104: break;
        case 9: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 105: break;
        case 20: 
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(E4X_INTAG);
          }
        case 106: break;
        case 44: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 107: break;
        case 53: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 108: break;
        case 31: 
          { yybegin(E4X); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 109: break;
        case 52: 
          { if(isJavaScriptCompatible("1.7")){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 110: break;
        case 40: 
          { int start = zzStartRead;
										int operatorLen = yycharat(0)=='+' ? 2 : 1;
										int yylen = yylength(); // Cache before first addToken() invalidates it
										//System.out.println("'" + yytext() + "': " + yylength() + ", " + (operatorLen+1));
										addToken(zzStartRead,zzStartRead+operatorLen-1, Token.OPERATOR);
										if (yylen>operatorLen+1) {
											//System.out.println((start+operatorLen) + ", " + (zzMarkedPos-2));
											addToken(start+operatorLen,zzMarkedPos-2, Token.WHITESPACE);
										}
										zzStartRead = zzCurrentPos = zzMarkedPos = zzMarkedPos - 1;
										if (isE4xSupported()) {
											// Scanning will continue with "<" as markup tag start
											yybegin(E4X, LANG_INDEX_E4X);
										}
										// Found e4x (or syntax error) but option not enabled;
										// Scanning will continue at "<" as operator
          }
        case 111: break;
        case 23: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
          }
        case 112: break;
        case 22: 
          { yybegin(YYINITIAL, LANG_INDEX_DEFAULT); addToken(Token.IDENTIFIER);
          }
        case 113: break;
        case 10: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 114: break;
        case 33: 
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_SINGLE);
          }
        case 115: break;
        case 42: 
          { addToken(Token.RESERVED_WORD);
          }
        case 116: break;
        case 62: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 117: break;
        case 64: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 118: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 119: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 120: break;
        case 4: 
          { addNullToken(); return firstToken;
          }
        case 121: break;
        case 63: 
          { int temp = zzStartRead; addToken(start,zzStartRead-1, Token.FUNCTION); start = temp; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 122: break;
        case 19: 
          { addEndToken(INTERNAL_E4X); return firstToken;
          }
        case 123: break;
        case 34: 
          { yybegin(E4X_INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 124: break;
        case 25: 
          { addToken(start,zzStartRead-1, Token.FUNCTION); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
          }
        case 125: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 126: break;
        case 36: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 127: break;
        case 60: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 128: break;
        case 56: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 129: break;
        case 1: 
          { 
          }
        case 130: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 383: break;
            case E4X: {
              addEndToken(INTERNAL_E4X); return firstToken;
            }
            case 384: break;
            case E4X_INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_INTAG); return firstToken;
            }
            case 385: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 386: break;
            case E4X_PI: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
            }
            case 387: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 388: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 389: break;
            case E4X_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
            }
            case 390: break;
            case E4X_DTD: {
              addToken(start,zzStartRead-1, Token.FUNCTION); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
            }
            case 391: break;
            case E4X_INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_SINGLE); return firstToken;
            }
            case 392: break;
            case E4X_INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_DOUBLE); return firstToken;
            }
            case 393: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 394: break;
            case E4X_CDATA: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_MARKUP_CDATA); return firstToken;
            }
            case 395: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
