/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.ser;

import com.fasterxml.jackson.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.codehaus.jackson.type.JavaType;

public class XmlSerializerProvider
extends StdSerializerProvider {
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup rootNames) {
        this._rootNameLookup = rootNames;
    }

    public XmlSerializerProvider(SerializationConfig config, XmlSerializerProvider src, SerializerFactory f) {
        super(config, (StdSerializerProvider)src, f);
        this._rootNameLookup = src._rootNameLookup;
    }

    protected StdSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new XmlSerializerProvider(config, this, jsf);
    }

    protected void _serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonProcessingException {
        QName rootName = value == null ? ROOT_NAME_FOR_NULL : this._rootNameLookup.findRootName(value.getClass(), (MapperConfig<?>)this._config);
        ToXmlGenerator xgen = (ToXmlGenerator)jgen;
        xgen.setNextName(rootName);
        xgen.initGenerator();
        super._serializeValue(jgen, value);
    }

    protected void _serializeValue(JsonGenerator jgen, Object value, JavaType rootType) throws IOException, JsonProcessingException {
        QName rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
        ToXmlGenerator xgen = (ToXmlGenerator)jgen;
        xgen.setNextName(rootName);
        xgen.initGenerator();
        super._serializeValue(jgen, value, rootType);
    }
}

