/*
 * Decompiled with CFR 0.152.
 */
package hirondelle.date4j;

import hirondelle.date4j.DateTime;
import hirondelle.date4j.Util;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DateTimeFormatter {
    private final String fFormat;
    private final Locale fLocale;
    private Collection<InterpretedRange> fInterpretedRanges;
    private Collection<EscapedRange> fEscapedRanges;
    private final Map<Locale, List<String>> fMonths = new LinkedHashMap<Locale, List<String>>();
    private final Map<Locale, List<String>> fWeekdays = new LinkedHashMap<Locale, List<String>>();
    private final Map<Locale, List<String>> fAmPm = new LinkedHashMap<Locale, List<String>>();
    private final CustomLocalization fCustomLocalization;
    private static final String ESCAPE_CHAR = "|";
    private static final Pattern ESCAPED_RANGE = Pattern.compile("\\|[^\\|]*\\|");
    private static final String YYYY = "YYYY";
    private static final String YY = "YY";
    private static final String M = "M";
    private static final String MM = "MM";
    private static final String MMM = "MMM";
    private static final String MMMM = "MMMM";
    private static final String D = "D";
    private static final String DD = "DD";
    private static final String WWW = "WWW";
    private static final String WWWW = "WWWW";
    private static final String hh = "hh";
    private static final String h = "h";
    private static final String m = "m";
    private static final String mm = "mm";
    private static final String s = "s";
    private static final String ss = "ss";
    private static final String h12 = "h12";
    private static final String hh12 = "hh12";
    private static final int AM = 0;
    private static final int PM = 1;
    private static final String a = "a";
    private static final Pattern FRACTIONALS = Pattern.compile("f{1,9}");
    private static final String EMPTY_STRING = "";
    private static final List<String> TOKENS = new ArrayList<String>();

    DateTimeFormatter(String aFormat) {
        this.fFormat = aFormat;
        this.fLocale = null;
        this.fCustomLocalization = null;
        this.validateState();
    }

    DateTimeFormatter(String aFormat, Locale aLocale) {
        this.fFormat = aFormat;
        this.fLocale = aLocale;
        this.fCustomLocalization = null;
        this.validateState();
    }

    DateTimeFormatter(String aFormat, List<String> aMonths, List<String> aWeekdays, List<String> aAmPmIndicators) {
        this.fFormat = aFormat;
        this.fLocale = null;
        this.fCustomLocalization = new CustomLocalization(aMonths, aWeekdays, aAmPmIndicators);
        this.validateState();
    }

    String format(DateTime aDateTime) {
        this.fEscapedRanges = new ArrayList<EscapedRange>();
        this.fInterpretedRanges = new ArrayList<InterpretedRange>();
        this.findEscapedRanges();
        this.interpretInput(aDateTime);
        return this.produceFinalOutput();
    }

    private void findEscapedRanges() {
        Matcher matcher = ESCAPED_RANGE.matcher(this.fFormat);
        while (matcher.find()) {
            EscapedRange escapedRange = new EscapedRange();
            escapedRange.Start = matcher.start();
            escapedRange.End = matcher.end() - 1;
            this.fEscapedRanges.add(escapedRange);
        }
    }

    private boolean isInEscapedRange(InterpretedRange aInterpretedRange) {
        boolean result = false;
        for (EscapedRange escapedRange : this.fEscapedRanges) {
            if (escapedRange.Start > aInterpretedRange.Start || aInterpretedRange.Start > escapedRange.End) continue;
            result = true;
            break;
        }
        return result;
    }

    private void interpretInput(DateTime aDateTime) {
        String format = this.fFormat;
        for (String token : TOKENS) {
            Pattern pattern = Pattern.compile(token);
            Matcher matcher = pattern.matcher(format);
            while (matcher.find()) {
                InterpretedRange interpretedRange = new InterpretedRange();
                interpretedRange.Start = matcher.start();
                interpretedRange.End = matcher.end() - 1;
                if (this.isInEscapedRange(interpretedRange)) continue;
                interpretedRange.Text = this.interpretThe(matcher.group(), aDateTime);
                this.fInterpretedRanges.add(interpretedRange);
            }
            format = format.replace(token, this.withCharDenotingAlreadyInterpreted(token));
        }
    }

    private String withCharDenotingAlreadyInterpreted(String aToken) {
        StringBuilder result = new StringBuilder();
        for (int idx = 1; idx <= aToken.length(); ++idx) {
            result.append("@");
        }
        return result.toString();
    }

    private String produceFinalOutput() {
        StringBuilder result = new StringBuilder();
        for (int idx = 0; idx < this.fFormat.length(); ++idx) {
            String letter = this.nextLetter(idx);
            InterpretedRange interpretation = this.getInterpretation(idx);
            if (interpretation != null) {
                result.append(interpretation.Text);
                idx = interpretation.End;
                continue;
            }
            if (ESCAPE_CHAR.equals(letter)) continue;
            result.append(letter);
        }
        return result.toString();
    }

    private InterpretedRange getInterpretation(int aIdx) {
        InterpretedRange result = null;
        for (InterpretedRange interpretedRange : this.fInterpretedRanges) {
            if (interpretedRange.Start != aIdx) continue;
            result = interpretedRange;
        }
        return result;
    }

    private String nextLetter(int aIdx) {
        return this.fFormat.substring(aIdx, aIdx + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String interpretThe(String aCurrentToken, DateTime aDateTime) {
        String result = EMPTY_STRING;
        if (YYYY.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getYear());
        }
        if (YY.equals(aCurrentToken)) {
            return this.noCentury(this.valueStr(aDateTime.getYear()));
        }
        if (MMMM.equals(aCurrentToken)) {
            int month = aDateTime.getMonth();
            return this.fullMonth(month);
        }
        if (MMM.equals(aCurrentToken)) {
            int month = aDateTime.getMonth();
            return this.firstThreeChars(this.fullMonth(month));
        }
        if (MM.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(aDateTime.getMonth()));
        }
        if (M.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getMonth());
        }
        if (DD.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(aDateTime.getDay()));
        }
        if (D.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getDay());
        }
        if (WWWW.equals(aCurrentToken)) {
            int weekday = aDateTime.getWeekDay();
            return this.fullWeekday(weekday);
        }
        if (WWW.equals(aCurrentToken)) {
            int weekday = aDateTime.getWeekDay();
            return this.firstThreeChars(this.fullWeekday(weekday));
        }
        if (hh.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(aDateTime.getHour()));
        }
        if (h.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getHour());
        }
        if (h12.equals(aCurrentToken)) {
            return this.valueStr(this.twelveHourStyle(aDateTime.getHour()));
        }
        if (hh12.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(this.twelveHourStyle(aDateTime.getHour())));
        }
        if (a.equals(aCurrentToken)) {
            int hour = aDateTime.getHour();
            return this.amPmIndicator(hour);
        }
        if (mm.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(aDateTime.getMinute()));
        }
        if (m.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getMinute());
        }
        if (ss.equals(aCurrentToken)) {
            return this.addLeadingZero(this.valueStr(aDateTime.getSecond()));
        }
        if (s.equals(aCurrentToken)) {
            return this.valueStr(aDateTime.getSecond());
        }
        if (!aCurrentToken.startsWith("f")) throw new IllegalArgumentException("Unknown token in date formatting pattern: " + aCurrentToken);
        Matcher matcher = FRACTIONALS.matcher(aCurrentToken);
        if (!matcher.matches()) throw new IllegalArgumentException("Unknown token in date formatting pattern: " + aCurrentToken);
        String nanos = this.nanosWithLeadingZeroes(aDateTime.getNanoseconds());
        int numDecimalsToShow = aCurrentToken.length();
        return this.firstNChars(nanos, numDecimalsToShow);
    }

    private String valueStr(Object aItem) {
        String result = EMPTY_STRING;
        if (aItem != null) {
            result = String.valueOf(aItem);
        }
        return result;
    }

    private String noCentury(String aItem) {
        String result = EMPTY_STRING;
        if (Util.textHasContent(aItem)) {
            result = aItem.substring(2);
        }
        return result;
    }

    private String nanosWithLeadingZeroes(Integer aNanos) {
        String result = this.valueStr(aNanos);
        while (result.length() < 9) {
            result = "0" + result;
        }
        return result;
    }

    private String addLeadingZero(String aTimePart) {
        String result = aTimePart;
        if (Util.textHasContent(aTimePart) && aTimePart.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String firstThreeChars(String aText) {
        String result = aText;
        if (Util.textHasContent(aText) && aText.length() >= 3) {
            result = aText.substring(0, 3);
        }
        return result;
    }

    private String fullMonth(Integer aMonth) {
        String result = EMPTY_STRING;
        if (aMonth != null) {
            if (this.fCustomLocalization != null) {
                result = this.lookupCustomMonthFor(aMonth);
            } else if (this.fLocale != null) {
                result = this.lookupMonthFor(aMonth);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return result;
    }

    private String lookupCustomMonthFor(Integer aMonth) {
        return this.fCustomLocalization.Months.get(aMonth - 1);
    }

    private String lookupMonthFor(Integer aMonth) {
        String result = EMPTY_STRING;
        if (!this.fMonths.containsKey(this.fLocale)) {
            ArrayList<String> months = new ArrayList<String>();
            SimpleDateFormat format = new SimpleDateFormat(MMMM, this.fLocale);
            for (int idx = 0; idx <= 11; ++idx) {
                GregorianCalendar firstDayOfMonth = new GregorianCalendar();
                firstDayOfMonth.set(1, 2000);
                firstDayOfMonth.set(2, idx);
                firstDayOfMonth.set(5, 15);
                String monthText = format.format(firstDayOfMonth.getTime());
                months.add(monthText);
            }
            this.fMonths.put(this.fLocale, months);
        }
        result = this.fMonths.get(this.fLocale).get(aMonth - 1);
        return result;
    }

    private String fullWeekday(Integer aWeekday) {
        String result = EMPTY_STRING;
        if (aWeekday != null) {
            if (this.fCustomLocalization != null) {
                result = this.lookupCustomWeekdayFor(aWeekday);
            } else if (this.fLocale != null) {
                result = this.lookupWeekdayFor(aWeekday);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return result;
    }

    private String lookupCustomWeekdayFor(Integer aWeekday) {
        return this.fCustomLocalization.Weekdays.get(aWeekday - 1);
    }

    private String lookupWeekdayFor(Integer aWeekday) {
        String result = EMPTY_STRING;
        if (!this.fWeekdays.containsKey(this.fLocale)) {
            ArrayList<String> weekdays = new ArrayList<String>();
            SimpleDateFormat format = new SimpleDateFormat("EEEE", this.fLocale);
            for (int idx = 8; idx <= 14; ++idx) {
                GregorianCalendar firstDayOfWeek = new GregorianCalendar();
                firstDayOfWeek.set(1, 2009);
                firstDayOfWeek.set(2, 1);
                firstDayOfWeek.set(5, idx);
                String weekdayText = format.format(firstDayOfWeek.getTime());
                weekdays.add(weekdayText);
            }
            this.fWeekdays.put(this.fLocale, weekdays);
        }
        result = this.fWeekdays.get(this.fLocale).get(aWeekday - 1);
        return result;
    }

    private String firstNChars(String aText, int aN) {
        String result = aText;
        if (Util.textHasContent(aText) && aText.length() >= aN) {
            result = aText.substring(0, aN);
        }
        return result;
    }

    private Integer twelveHourStyle(Integer aHour) {
        Integer result = aHour;
        if (aHour != null) {
            if (aHour == 0) {
                result = 12;
            } else if (aHour > 12) {
                result = aHour - 12;
            }
        }
        return result;
    }

    private String amPmIndicator(Integer aHour) {
        String result = EMPTY_STRING;
        if (aHour != null) {
            if (this.fCustomLocalization != null) {
                result = this.lookupCustomAmPmFor(aHour);
            } else if (this.fLocale != null) {
                result = this.lookupAmPmFor(aHour);
            } else {
                throw new IllegalArgumentException("Your date pattern requires either a Locale, or your own custom localizations for text:" + Util.quote(this.fFormat));
            }
        }
        return result;
    }

    private String lookupCustomAmPmFor(Integer aHour) {
        String result = EMPTY_STRING;
        result = aHour < 12 ? this.fCustomLocalization.AmPmIndicators.get(0) : this.fCustomLocalization.AmPmIndicators.get(1);
        return result;
    }

    private String lookupAmPmFor(Integer aHour) {
        String result = EMPTY_STRING;
        if (!this.fAmPm.containsKey(this.fLocale)) {
            ArrayList<String> indicators = new ArrayList<String>();
            indicators.add(this.getAmPmTextFor(6));
            indicators.add(this.getAmPmTextFor(18));
            this.fAmPm.put(this.fLocale, indicators);
        }
        result = aHour < 12 ? this.fAmPm.get(this.fLocale).get(0) : this.fAmPm.get(this.fLocale).get(1);
        return result;
    }

    private String getAmPmTextFor(Integer aHour) {
        SimpleDateFormat format = new SimpleDateFormat(a, this.fLocale);
        GregorianCalendar someDay = new GregorianCalendar();
        someDay.set(1, 2000);
        someDay.set(2, 6);
        someDay.set(5, 15);
        someDay.set(11, aHour);
        return format.format(someDay.getTime());
    }

    private void validateState() {
        if (!Util.textHasContent(this.fFormat)) {
            throw new IllegalArgumentException("DateTime format has no content.");
        }
    }

    static {
        TOKENS.add(YYYY);
        TOKENS.add(YY);
        TOKENS.add(MMMM);
        TOKENS.add(MMM);
        TOKENS.add(MM);
        TOKENS.add(M);
        TOKENS.add(DD);
        TOKENS.add(D);
        TOKENS.add(WWWW);
        TOKENS.add(WWW);
        TOKENS.add(hh12);
        TOKENS.add(h12);
        TOKENS.add(hh);
        TOKENS.add(h);
        TOKENS.add(mm);
        TOKENS.add(m);
        TOKENS.add(ss);
        TOKENS.add(s);
        TOKENS.add(a);
        TOKENS.add("fffffffff");
        TOKENS.add("ffffffff");
        TOKENS.add("fffffff");
        TOKENS.add("ffffff");
        TOKENS.add("fffff");
        TOKENS.add("ffff");
        TOKENS.add("fff");
        TOKENS.add("ff");
        TOKENS.add("f");
    }

    private static final class EscapedRange {
        int Start;
        int End;

        private EscapedRange() {
        }
    }

    private static final class InterpretedRange {
        int Start;
        int End;
        String Text;

        private InterpretedRange() {
        }

        public String toString() {
            return "Start:" + this.Start + " End:" + this.End + " '" + this.Text + "'";
        }
    }

    private final class CustomLocalization {
        List<String> Months;
        List<String> Weekdays;
        List<String> AmPmIndicators;

        CustomLocalization(List<String> aMonths, List<String> aWeekdays, List<String> aAmPm) {
            if (aMonths.size() != 12) {
                throw new IllegalArgumentException("Your List of custom months must have size 12, but its size is " + aMonths.size());
            }
            if (aWeekdays.size() != 7) {
                throw new IllegalArgumentException("Your List of custom weekdays must have size 7, but its size is " + aWeekdays.size());
            }
            if (aAmPm.size() != 2) {
                throw new IllegalArgumentException("Your List of custom a.m./p.m. indicators must have size 2, but its size is " + aAmPm.size());
            }
            this.Months = aMonths;
            this.Weekdays = aWeekdays;
            this.AmPmIndicators = aAmPm;
        }
    }
}

