/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.security;

import com.google.common.base.Joiner;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WwwAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WwwAuthFilter.class);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String AUTH_PREFIX = "Basic ";
    private static final String ROOT_IDENTIFY = "root";
    private static final String ROOT_DEFAULT_USERNAME = "root";
    private static final String ROOT_DEFAULT_PASSWORD = "root";
    private static final String GUEST_IDENTIFY = "guest";
    private static final String GUEST_DEFAULT_USERNAME = "guest";
    private static final String GUEST_DEFAULT_PASSWORD = "guest";
    private String rootUsername;
    private String rootPassword;
    private String guestUsername;
    private String guestPassword;

    public void init(FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        URL classLoaderURL = Thread.currentThread().getContextClassLoader().getResource("");
        if (null != classLoaderURL) {
            String configFilePath = Joiner.on((String)FILE_SEPARATOR).join((Object)classLoaderURL.getPath(), (Object)"conf", new Object[]{"auth.properties"});
            try {
                props.load(new FileInputStream(configFilePath));
            }
            catch (IOException ex) {
                log.warn("Cannot found auth config file, use default auth config.");
            }
        }
        this.rootUsername = props.getProperty("root.username", "root");
        this.rootPassword = props.getProperty("root.password", "root");
        this.guestUsername = props.getProperty("guest.username", "guest");
        this.guestPassword = props.getProperty("guest.password", "guest");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader("authorization");
        if (null != authorization && authorization.length() > AUTH_PREFIX.length()) {
            authorization = authorization.substring(AUTH_PREFIX.length(), authorization.length());
            if ((this.rootUsername + ":" + this.rootPassword).equals(new String(Base64.decodeBase64((String)authorization)))) {
                this.authenticateSuccess(httpResponse, false);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else if ((this.guestUsername + ":" + this.guestPassword).equals(new String(Base64.decodeBase64((String)authorization)))) {
                this.authenticateSuccess(httpResponse, true);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.needAuthenticate(httpResponse);
            }
        } else {
            this.needAuthenticate(httpResponse);
        }
    }

    private void authenticateSuccess(HttpServletResponse response, boolean isGuest) {
        response.setStatus(200);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("identify", isGuest ? "guest" : "root");
    }

    private void needAuthenticate(HttpServletResponse response) {
        response.setStatus(401);
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("WWW-authenticate", "Basic Realm=\"Elastic Job Console Auth\"");
    }

    public void destroy() {
    }
}

