/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.box.jwtauth;

import com.box.sdkgen.box.jwtauth.JwtConfigAppSettings;
import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class JwtConfigFile
extends SerializableObject {
    @JsonProperty(value="enterpriseID")
    protected String enterpriseId;
    @JsonProperty(value="userID")
    protected String userId;
    protected final JwtConfigAppSettings boxAppSettings;

    public JwtConfigFile(@JsonProperty(value="boxAppSettings") JwtConfigAppSettings boxAppSettings) {
        this.boxAppSettings = boxAppSettings;
    }

    protected JwtConfigFile(Builder builder) {
        this.enterpriseId = builder.enterpriseId;
        this.userId = builder.userId;
        this.boxAppSettings = builder.boxAppSettings;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public String getUserId() {
        return this.userId;
    }

    public JwtConfigAppSettings getBoxAppSettings() {
        return this.boxAppSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtConfigFile casted = (JwtConfigFile)o;
        return Objects.equals(this.enterpriseId, casted.enterpriseId) && Objects.equals(this.userId, casted.userId) && Objects.equals(this.boxAppSettings, casted.boxAppSettings);
    }

    public int hashCode() {
        return Objects.hash(this.enterpriseId, this.userId, this.boxAppSettings);
    }

    public String toString() {
        return "JwtConfigFile{enterpriseId='" + this.enterpriseId + '\'' + ", userId='" + this.userId + '\'' + ", boxAppSettings='" + this.boxAppSettings + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected String enterpriseId;
        protected String userId;
        protected final JwtConfigAppSettings boxAppSettings;

        public Builder(JwtConfigAppSettings boxAppSettings) {
            this.boxAppSettings = boxAppSettings;
        }

        public Builder enterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public JwtConfigFile build() {
            return new JwtConfigFile(this);
        }
    }
}

