/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.legalholdpolicyassignment;

import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.file.File;
import com.box.sdkgen.schemas.folder.Folder;
import com.box.sdkgen.schemas.legalholdpolicyassigneditem.LegalHoldPolicyAssignedItem;
import com.box.sdkgen.schemas.legalholdpolicyassignmentbase.LegalHoldPolicyAssignmentBase;
import com.box.sdkgen.schemas.legalholdpolicyassignmentbase.LegalHoldPolicyAssignmentBaseTypeField;
import com.box.sdkgen.schemas.legalholdpolicymini.LegalHoldPolicyMini;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class LegalHoldPolicyAssignment
extends LegalHoldPolicyAssignmentBase {
    @JsonProperty(value="legal_hold_policy")
    protected LegalHoldPolicyMini legalHoldPolicy;
    @JsonProperty(value="assigned_to")
    protected LegalHoldPolicyAssignedItem assignedTo;
    @JsonProperty(value="assigned_by")
    protected UserMini assignedBy;
    @JsonProperty(value="assigned_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime assignedAt;
    @JsonProperty(value="deleted_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected OffsetDateTime deletedAt;

    public LegalHoldPolicyAssignment() {
    }

    protected LegalHoldPolicyAssignment(Builder builder) {
        super(builder);
        this.legalHoldPolicy = builder.legalHoldPolicy;
        this.assignedTo = builder.assignedTo;
        this.assignedBy = builder.assignedBy;
        this.assignedAt = builder.assignedAt;
        this.deletedAt = builder.deletedAt;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public LegalHoldPolicyMini getLegalHoldPolicy() {
        return this.legalHoldPolicy;
    }

    public LegalHoldPolicyAssignedItem getAssignedTo() {
        return this.assignedTo;
    }

    public UserMini getAssignedBy() {
        return this.assignedBy;
    }

    public OffsetDateTime getAssignedAt() {
        return this.assignedAt;
    }

    public OffsetDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalHoldPolicyAssignment casted = (LegalHoldPolicyAssignment)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.legalHoldPolicy, casted.legalHoldPolicy) && Objects.equals(this.assignedTo, casted.assignedTo) && Objects.equals(this.assignedBy, casted.assignedBy) && Objects.equals(this.assignedAt, casted.assignedAt) && Objects.equals(this.deletedAt, casted.deletedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.legalHoldPolicy, this.assignedTo, this.assignedBy, this.assignedAt, this.deletedAt);
    }

    @Override
    public String toString() {
        return "LegalHoldPolicyAssignment{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", legalHoldPolicy='" + this.legalHoldPolicy + '\'' + ", assignedTo='" + this.assignedTo + '\'' + ", assignedBy='" + this.assignedBy + '\'' + ", assignedAt='" + this.assignedAt + '\'' + ", deletedAt='" + this.deletedAt + '\'' + "}";
    }

    public static class Builder
    extends LegalHoldPolicyAssignmentBase.Builder {
        protected LegalHoldPolicyMini legalHoldPolicy;
        protected LegalHoldPolicyAssignedItem assignedTo;
        protected UserMini assignedBy;
        protected OffsetDateTime assignedAt;
        protected OffsetDateTime deletedAt;

        public Builder legalHoldPolicy(LegalHoldPolicyMini legalHoldPolicy) {
            this.legalHoldPolicy = legalHoldPolicy;
            return this;
        }

        public Builder assignedTo(File assignedTo) {
            this.assignedTo = new LegalHoldPolicyAssignedItem(assignedTo);
            return this;
        }

        public Builder assignedTo(Folder assignedTo) {
            this.assignedTo = new LegalHoldPolicyAssignedItem(assignedTo);
            return this;
        }

        public Builder assignedTo(WebLink assignedTo) {
            this.assignedTo = new LegalHoldPolicyAssignedItem(assignedTo);
            return this;
        }

        public Builder assignedTo(LegalHoldPolicyAssignedItem assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public Builder assignedBy(UserMini assignedBy) {
            this.assignedBy = assignedBy;
            return this;
        }

        public Builder assignedAt(OffsetDateTime assignedAt) {
            this.assignedAt = assignedAt;
            return this;
        }

        public Builder deletedAt(OffsetDateTime deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @Override
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder type(LegalHoldPolicyAssignmentBaseTypeField type) {
            this.type = new EnumWrapper<LegalHoldPolicyAssignmentBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<LegalHoldPolicyAssignmentBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public LegalHoldPolicyAssignment build() {
            return new LegalHoldPolicyAssignment(this);
        }
    }
}

